/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.data.Availability;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.data.NumericData;
import org.hawkular.alerts.api.model.data.StringData;

public class AlertData {
    @JsonInclude
    private final String id;
    @JsonInclude
    private final long timestamp;
    @JsonInclude
    private final String value;
    @JsonInclude
    private final String type;

    public AlertData() {
        this(null, 0L, null, null);
    }

    public AlertData(String id, long timestamp, String value, String type) {
        this.id = id;
        this.timestamp = timestamp;
        this.value = value;
        this.type = type;
    }

    public Data convert() {
        if (this.type != null && !this.type.isEmpty() && this.type.equalsIgnoreCase("numeric")) {
            return new NumericData(this.id, this.timestamp, Double.valueOf(this.value));
        }
        if (this.type != null && !this.type.isEmpty() && this.type.equalsIgnoreCase("availability")) {
            return new Availability(this.id, this.timestamp, Availability.AvailabilityType.valueOf((String)this.value));
        }
        return new StringData(this.id, this.timestamp, this.value);
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlertData other = (AlertData)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "AlertData [id=" + this.id + ", timestamp=" + this.timestamp + ", value=" + this.value + ", type=" + this.type + "]";
    }
}

