/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.NumericData;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.alerts.bus.messages.MetricDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeMetricIds, String metricId) {
        if (null == activeMetricIds) {
            return true;
        }
        return activeMetricIds.contains(metricId);
    }

    protected void onBasicMessage(MetricDataMessage msg) {
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        this.log.debugf("Message received with [%s] datums.", metricData.getData().size());
        List<MetricDataMessage.SingleMetric> data = metricData.getData();
        ArrayList<NumericData> alertData = new ArrayList<NumericData>(data.size());
        Set<String> activeMetricIds = this.cacheManager.getActiveDataIds();
        for (MetricDataMessage.SingleMetric m : data) {
            if (!this.isNeeded(activeMetricIds, m.getSource())) continue;
            alertData.add(new NumericData(m.getSource(), m.getTimestamp(), Double.valueOf(m.getValue())));
        }
        this.log.debugf("Sending [%s] datums to Alerting, filtered [%s] not used in Triggers.", alertData.size(), metricData.getData().size() - alertData.size());
        try {
            this.alerts.sendData(alertData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

