/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.Map;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.api.BusRegistrationMessage;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsPluginsQueue")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ActionPluginRegistrationListener
extends BasicMessageListener<BusRegistrationMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionPluginRegistrationListener.class);
    @EJB
    DefinitionsService definitions;

    protected void onBasicMessage(BusRegistrationMessage msg) {
        this.log.debugf("Message received: [%s]", (Object)msg);
        String actionPlugin = msg.getActionPlugin();
        try {
            if (this.definitions.getActionPlugin(actionPlugin) == null) {
                Set properties = msg.getPropertyNames();
                Map defaultProperties = msg.getDefaultProperties();
                if (defaultProperties != null && !defaultProperties.isEmpty()) {
                    this.definitions.addActionPlugin(actionPlugin, defaultProperties);
                } else {
                    this.definitions.addActionPlugin(actionPlugin, properties);
                }
                this.msgLog.infoActionPluginRegistration(actionPlugin);
            } else {
                this.msgLog.warnActionPluginAlreadyRegistered(actionPlugin);
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService(e.getMessage());
        }
    }
}

