/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.Collections;
import java.util.UUID;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.cmdgw.api.DeployApplicationResponse;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularCommandEvent")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CommandEventListener
extends BasicMessageListener<BasicMessage> {
    private final Logger log = Logger.getLogger(CommandEventListener.class);
    @EJB
    AlertsService alerts;

    protected void onBasicMessage(BasicMessage msg) {
        if (msg instanceof DeployApplicationResponse) {
            DeployApplicationResponse dar = (DeployApplicationResponse)msg;
            String canonicalPathString = dar.getResourcePath();
            CanonicalPath canonicalPath = CanonicalPath.fromString((String)canonicalPathString);
            String tenantId = canonicalPath.ids().getTenantId();
            String feedId = canonicalPath.ids().getFeedId();
            String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
            resourceId = resourceId.substring(0, resourceId.length() - 2);
            String eventId = UUID.randomUUID().toString();
            String dataId = feedId + "/" + resourceId + "_DeployApplicationResponse";
            String category = "Hawkular Deployment";
            String text = dar.getStatus().name();
            Event event = new Event(tenantId, eventId, dataId, category, text);
            event.addContext("CanonicalPath", canonicalPathString);
            event.addContext("Message", dar.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("EVENT! " + event.toString()));
            }
            try {
                this.alerts.addEvents(Collections.singleton(event));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.log.error((Object)("Unexpected Event Message! " + msg.toJSON()));
        }
    }
}

