/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.init;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CacheManager {
    private final Logger log = Logger.getLogger(CacheManager.class);
    Set<String> activeDataIds;
    Set<String> activeAvailabityIds;
    @EJB
    DefinitionsService definitions;

    @PostConstruct
    public void init() {
        this.updateActiveIds();
        this.definitions.registerListener(new DefinitionsListener(){

            public void onChange(DefinitionsEvent event) {
                CacheManager.this.updateActiveIds();
            }
        }, DefinitionsEvent.Type.CONDITION_CHANGE, new DefinitionsEvent.Type[0]);
    }

    public Set<String> getActiveDataIds() {
        return this.activeDataIds;
    }

    public void setActiveDataIds(Set<String> activeDataIds) {
        this.activeDataIds = activeDataIds;
    }

    public Set<String> getActiveAvailabilityIds() {
        return this.activeAvailabityIds;
    }

    public void setActiveAvailabilityIds(Set<String> activeAvailabilityIds) {
        this.activeDataIds = activeAvailabilityIds;
    }

    private synchronized void updateActiveIds() {
        HashSet<String> dataIds = null;
        HashSet<String> availIds = null;
        try {
            Collection conditions = this.definitions.getAllConditions();
            dataIds = new HashSet<String>(conditions.size());
            availIds = new HashSet<String>(conditions.size());
            for (Condition c : conditions) {
                if (c instanceof AvailabilityCondition) {
                    availIds.add(c.getDataId());
                    continue;
                }
                dataIds.add(c.getDataId());
                if (!(c instanceof CompareCondition)) continue;
                dataIds.add(((CompareCondition)c).getData2Id());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"FAILED to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e);
            this.activeDataIds = null;
            this.activeAvailabityIds = null;
            return;
        }
        this.activeDataIds = Collections.unmodifiableSet(dataIds);
        this.activeAvailabityIds = Collections.unmodifiableSet(availIds);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updated activeDataIds! " + this.activeDataIds));
            this.log.debug((Object)("Updated activeAvailIds! " + this.activeAvailabityIds));
        }
    }
}

