/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.GsonAdapter;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.rules.RulesEngine;
import org.jboss.logging.Logger;

public class DbAlertsServiceImpl
implements AlertsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(DbAlertsServiceImpl.class);
    private static final int DELAY;
    private static final int PERIOD;
    private final List<Data> pendingData;
    private final List<Alert> alerts;
    private final Set<Dampening> pendingTimeouts;
    private final Map<Trigger, List<Set<ConditionEval>>> autoResolvedTriggers;
    private final Set<Trigger> disabledTriggers;
    private final Timer wakeUpTimer;
    private TimerTask rulesTask;
    private Gson gson;
    private final String DS_NAME;
    private DataSource ds;
    @EJB
    RulesEngine rules;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public DbAlertsServiceImpl() {
        this.log.debugf("Creating instance.", new Object[0]);
        this.pendingData = new CopyOnWriteArrayList<Data>();
        this.alerts = new CopyOnWriteArrayList<Alert>();
        this.pendingTimeouts = new CopyOnWriteArraySet<Dampening>();
        this.autoResolvedTriggers = new HashMap<Trigger, List<Set<ConditionEval>>>();
        this.disabledTriggers = new CopyOnWriteArraySet<Trigger>();
        this.wakeUpTimer = new Timer("DbAlertsServiceImpl-Timer");
        this.DS_NAME = System.getProperty("org.hawkular.alerts.engine.datasource", "java:jboss/datasources/HawkularDS");
    }

    public ActionsService getActions() {
        return this.actions;
    }

    public void setActions(ActionsService actions) {
        this.actions = actions;
    }

    public DefinitionsService getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(DefinitionsService definitions) {
        this.definitions = definitions;
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    public DataSource getDatasource() {
        return this.ds;
    }

    public void setDatasource(DataSource ds) {
        this.ds = ds;
    }

    @PostConstruct
    public void initServices() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(ConditionEval.class, new GsonAdapter());
        this.gson = gsonBuilder.create();
        if (this.ds == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.ds = (DataSource)ctx.lookup(this.DS_NAME);
            }
            catch (NamingException e) {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorCannotConnectWithDatasource(e.getMessage());
            }
        }
        this.reload();
    }

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringReader sr = null;
        try {
            c = this.ds.getConnection();
            String sql = "INSERT INTO HWK_ALERTS_ALERTS VALUES (?,?,?,?,?,?)";
            ps = c.prepareStatement(sql);
            for (Alert a : alerts) {
                ps.setString(1, a.getTenantId());
                ps.setString(2, a.getAlertId());
                ps.setString(3, a.getTriggerId());
                ps.setLong(4, a.getCtime());
                ps.setString(5, a.getStatus().name());
                sr = new StringReader(this.toJson(a));
                ps.setCharacterStream(6, sr);
                this.log.debugf("SQL: " + sql, new Object[0]);
                ps.executeUpdate();
                sr.close();
                sr = null;
            }
            this.close(c, ps, null);
            if (null != sr) {
                sr.close();
            }
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, ps, null);
                if (null != sr) {
                    sr.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Alert> getAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        ArrayList<Alert> alerts;
        block38: {
            if (this.isEmpty(tenantId)) {
                throw new IllegalArgumentException("TenantId must be not null");
            }
            if (this.ds == null) {
                throw new Exception("DataSource is null");
            }
            if (criteria != null) {
                this.log.debugf("getAlerts criteria: %s", (Object)criteria.toString());
            }
            boolean filter = null != criteria && criteria.hasCriteria();
            alerts = new ArrayList<Alert>();
            Connection c = null;
            Statement s = null;
            ResultSet rs = null;
            Reader r = null;
            try {
                c = this.ds.getConnection();
                s = c.createStatement();
                StringBuilder sql = new StringBuilder("SELECT a.triggerId, a.ctime, a.payload FROM HWK_ALERTS_ALERTS a");
                if (filter) {
                    int entries;
                    int filters = 0;
                    sql.append(" WHERE ");
                    if (this.isEmpty(criteria.getAlertIds())) {
                        if (!this.isEmpty(criteria.getAlertId())) {
                            sql.append(filters++ > 0 ? " AND " : " ");
                            sql.append("( a.alertId = '");
                            sql.append(criteria.getAlertId());
                            sql.append("' )");
                        }
                    } else {
                        sql.append(filters++ > 0 ? " AND " : " ");
                        sql.append("( a.alertId IN (");
                        entries = 0;
                        for (String alertId : criteria.getAlertIds()) {
                            if (this.isEmpty(alertId)) continue;
                            sql.append(entries++ > 0 ? "," : "");
                            sql.append("'");
                            sql.append(alertId);
                            sql.append("'");
                        }
                        sql.append(") )");
                    }
                    if (this.isEmpty(criteria.getTriggerIds())) {
                        if (!this.isEmpty(criteria.getTriggerId())) {
                            sql.append(filters++ > 0 ? " AND " : " ");
                            sql.append("( a.triggerId = '");
                            sql.append(criteria.getTriggerId());
                            sql.append("' )");
                        }
                    } else {
                        sql.append(filters++ > 0 ? " AND " : " ");
                        sql.append("( a.triggerId IN (");
                        entries = 0;
                        for (String triggerId : criteria.getTriggerIds()) {
                            if (this.isEmpty(triggerId)) continue;
                            sql.append(entries++ > 0 ? "," : "");
                            sql.append("'");
                            sql.append(triggerId);
                            sql.append("'");
                        }
                        sql.append(") )");
                    }
                    if (this.isEmpty(criteria.getStatusSet())) {
                        if (null != criteria.getStatus()) {
                            sql.append(filters++ > 0 ? " AND " : " ");
                            sql.append("( a.status = '");
                            sql.append(criteria.getStatus().name());
                            sql.append("' )");
                        }
                    } else {
                        sql.append(filters++ > 0 ? " AND " : " ");
                        sql.append("( a.status IN (");
                        entries = 0;
                        for (Alert.Status status : criteria.getStatusSet()) {
                            sql.append(entries++ > 0 ? "," : "");
                            sql.append("'");
                            sql.append(status.name());
                            sql.append("'");
                        }
                        sql.append(") )");
                    }
                    if (null != criteria.getStartTime()) {
                        sql.append(filters++ > 0 ? " AND " : " ");
                        sql.append("( a.ctime >= ");
                        sql.append(criteria.getStartTime());
                        sql.append(" )");
                    }
                    if (null != criteria.getEndTime()) {
                        sql.append(filters++ > 0 ? " AND " : " ");
                        sql.append("( a.ctime <= ");
                        sql.append(criteria.getEndTime());
                        sql.append(" )");
                    }
                    if (this.isEmpty(criteria.getTags())) {
                        Tag tag = criteria.getTag();
                        if (null != tag) {
                            sql.append(filters > 0 ? " AND " : " ");
                            sql.append("( EXISTS ( SELECT * FROM HWK_ALERTS_TAGS t WHERE t.triggerId = a.triggerId ");
                            if (!this.isEmpty(tag.getCategory()) && !this.isEmpty(tag.getName())) {
                                sql.append(" AND t.category = '");
                                sql.append(tag.getCategory());
                                sql.append("' AND t.name = '");
                                sql.append(tag.getName());
                                sql.append("' ");
                            } else if (!this.isEmpty(tag.getCategory())) {
                                sql.append(" AND t.category = '");
                                sql.append(tag.getCategory());
                                sql.append("' ");
                            } else if (!this.isEmpty(tag.getName())) {
                                sql.append(" AND t.name = '");
                                sql.append(tag.getName());
                                sql.append("' ");
                            }
                            sql.append(" ) )");
                        }
                    } else {
                        sql.append(filters > 0 ? " AND " : " ");
                        sql.append("(");
                        entries = 0;
                        for (Tag tag : criteria.getTags()) {
                            sql.append(entries++ > 0 ? " OR " : "");
                            sql.append("( EXISTS ( SELECT * FROM HWK_ALERTS_TAGS t WHERE t.triggerId = a.triggerId ");
                            if (!this.isEmpty(tag.getCategory()) && !this.isEmpty(tag.getName())) {
                                sql.append(" AND t.category = '");
                                sql.append(tag.getCategory());
                                sql.append("' AND t.name = '");
                                sql.append(tag.getName());
                                sql.append("' ");
                            } else if (!this.isEmpty(tag.getCategory())) {
                                sql.append(" AND t.category = '");
                                sql.append(tag.getCategory());
                                sql.append("' ");
                            } else if (!this.isEmpty(tag.getName())) {
                                sql.append(" AND t.name = '");
                                sql.append(tag.getName());
                                sql.append("' ");
                            }
                            sql.append(" ) )");
                        }
                        sql.append(")");
                    }
                }
                sql.append(" ORDER BY a.ctime");
                this.log.debugf("SQL: " + sql, new Object[0]);
                rs = s.executeQuery(sql.toString());
                while (rs.next()) {
                    Clob clob = rs.getClob(3);
                    r = clob.getCharacterStream();
                    Alert alert = this.fromJson(r, Alert.class);
                    r.close();
                    r = null;
                    alerts.add(alert);
                }
                this.close(c, s, rs);
                if (null == r) break block38;
            }
            catch (SQLException e) {
                try {
                    this.msgLog.errorDatabaseException(e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    this.close(c, s, rs);
                    if (null != r) {
                        r.close();
                    }
                    throw throwable;
                }
            }
            r.close();
        }
        this.log.debugf(alerts.isEmpty() ? "No Alerts Found" : "Alerts Found! " + alerts, new Object[0]);
        return alerts;
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private String toJson(Object resource) {
        this.log.debugf(this.gson.toJson(resource), new Object[0]);
        return this.gson.toJson(resource);
    }

    private <T> T fromJson(Reader json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    private void close(Connection c, Statement s, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.rulesTask.cancel();
        this.rules.clear();
        this.pendingData.clear();
        this.alerts.clear();
        this.pendingTimeouts.clear();
        this.autoResolvedTriggers.clear();
        this.disabledTriggers.clear();
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, DELAY, (long)PERIOD);
    }

    public void reload() {
        this.rules.reset();
        if (this.rulesTask != null) {
            this.rulesTask.cancel();
        }
        Collection triggers = null;
        try {
            triggers = this.definitions.getAllTriggers();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Triggers", e.getMessage());
        }
        if (triggers != null && !triggers.isEmpty()) {
            triggers.stream().filter(Trigger::isEnabled).forEach(this::reloadTrigger);
        }
        this.rules.addGlobal("log", this.log);
        this.rules.addGlobal("actions", this.actions);
        this.rules.addGlobal("alerts", this.alerts);
        this.rules.addGlobal("pendingTimeouts", this.pendingTimeouts);
        this.rules.addGlobal("autoResolvedTriggers", this.autoResolvedTriggers);
        this.rules.addGlobal("disabledTriggers", this.disabledTriggers);
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, DELAY, (long)PERIOD);
    }

    public void reloadTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger trigger = null;
        try {
            trigger = this.definitions.getTrigger(tenantId, triggerId);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
        }
        if (null == trigger) {
            this.log.debugf("Trigger not found for triggerId [" + triggerId + "], removing from rulebase if it exists", new Object[0]);
            Trigger doomedTrigger = new Trigger(triggerId, "doomed");
            this.removeTrigger(doomedTrigger);
            return;
        }
        this.reloadTrigger(trigger);
    }

    private void reloadTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.removeTrigger(trigger);
        if (trigger.isEnabled()) {
            try {
                Collection conditionSet = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                Collection dampenings = this.definitions.getTriggerDampenings(trigger.getTenantId(), trigger.getId(), null);
                this.rules.addFact(trigger);
                this.rules.addFacts(conditionSet);
                if (!dampenings.isEmpty()) {
                    this.rules.addFacts(dampenings);
                }
            }
            catch (Exception e) {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorDefinitionsService("Conditions/Dampening", e.getMessage());
            }
        }
    }

    private void removeTrigger(Trigger trigger) {
        if (null != this.rules.getFact(trigger)) {
            this.rules.removeFact(trigger);
            String triggerId = trigger.getId();
            this.rules.removeFacts(t -> {
                if (t instanceof Dampening) {
                    return ((Dampening)t).getTriggerId().equals(triggerId);
                }
                if (t instanceof Condition) {
                    return ((Condition)t).getTriggerId().equals(triggerId);
                }
                return false;
            });
        } else {
            this.log.debugf("Trigger not found. Not removed from rulebase %s", (Object)trigger);
        }
    }

    public void sendData(Collection<Data> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.addAll(data);
    }

    public void sendData(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.add(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisabledTriggers() {
        try {
            for (Trigger t : this.disabledTriggers) {
                try {
                    t.setEnabled(false);
                    this.definitions.updateTrigger(t.getTenantId(), t);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to persist updated trigger. Could not autoDisable %s", (Object)t);
                }
            }
        }
        finally {
            this.disabledTriggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoResolvedTriggers() {
        try {
            for (Map.Entry<Trigger, List<Set<ConditionEval>>> entry : this.autoResolvedTriggers.entrySet()) {
                Trigger t = entry.getKey();
                try {
                    if (!t.isAutoResolveAlerts()) continue;
                    this.resolveAlertsForTrigger(t.getTenantId(), t.getId(), "AUTO", null, entry.getValue());
                }
                catch (Exception e) {
                    this.log.errorf("Failed to resolve Alerts. Could not AutoResolve alerts for trigger %s", (Object)t);
                }
            }
        }
        finally {
            this.autoResolvedTriggers.clear();
        }
    }

    public void ackAlerts(String tenantId, Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToAck = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToAck) {
            a.setStatus(Alert.Status.ACKNOWLEDGED);
            a.setAckBy(ackBy);
            a.setAckNotes(ackNotes);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlerts(String tenantId, Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToResolve = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlertsForTrigger(String tenantId, String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        List<Alert> alertsToResolve = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringReader sr = null;
        try {
            c = this.ds.getConnection();
            StringBuilder sql = new StringBuilder("UPDATE HWK_ALERTS_ALERTS SET ").append("status = '").append(alert.getStatus().name()).append("', ").append("payload = ? ").append("WHERE alertId = '").append(alert.getAlertId()).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            ps = c.prepareStatement(sql.toString());
            sr = new StringReader(this.toJson(alert));
            ps.setCharacterStream(1, sr);
            this.log.debugf("SQL: " + sql, new Object[0]);
            ps.executeUpdate();
            sr.close();
            sr = null;
            this.close(c, ps, null);
            if (null != sr) {
                sr.close();
            }
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, ps, null);
                if (null != sr) {
                    sr.close();
                }
                throw throwable;
            }
        }
        return alert;
    }

    static {
        String sDelay = System.getProperty("org.hawkular.alerts.engine.DELAY");
        String sPeriod = System.getProperty("org.hawkular.alerts.engine.PERIOD");
        int dDelay = 1000;
        int dPeriod = 2000;
        try {
            dDelay = Integer.parseInt(sDelay);
            dPeriod = Integer.parseInt(sPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DELAY = dDelay;
        PERIOD = dPeriod;
    }

    private class RulesInvoker
    extends TimerTask {
        private RulesInvoker() {
        }

        @Override
        public void run() {
            int numTimeouts = this.checkPendingTimeouts();
            if (!DbAlertsServiceImpl.this.pendingData.isEmpty() || numTimeouts > 0) {
                DbAlertsServiceImpl.this.log.debugf("Executing rules engine on [%1d] datums and [%2d] dampening timeouts.", (Object)DbAlertsServiceImpl.this.pendingData.size(), (Object)numTimeouts);
                try {
                    if (DbAlertsServiceImpl.this.pendingData.isEmpty()) {
                        DbAlertsServiceImpl.this.rules.fireNoData();
                    } else {
                        DbAlertsServiceImpl.this.rules.addData(DbAlertsServiceImpl.this.pendingData);
                        DbAlertsServiceImpl.this.pendingData.clear();
                    }
                    DbAlertsServiceImpl.this.rules.fire();
                    DbAlertsServiceImpl.this.addAlerts(DbAlertsServiceImpl.this.alerts);
                    DbAlertsServiceImpl.this.alerts.clear();
                    DbAlertsServiceImpl.this.handleDisabledTriggers();
                    DbAlertsServiceImpl.this.handleAutoResolvedTriggers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbAlertsServiceImpl.this.log.debugf("Error on rules processing: " + e, new Object[0]);
                    DbAlertsServiceImpl.this.msgLog.errorProcessingRules(e.getMessage());
                }
                finally {
                    DbAlertsServiceImpl.this.alerts.clear();
                }
            }
        }

        private int checkPendingTimeouts() {
            if (DbAlertsServiceImpl.this.pendingTimeouts.isEmpty()) {
                return 0;
            }
            long now = System.currentTimeMillis();
            HashSet<Dampening> timeouts = null;
            for (Dampening d : DbAlertsServiceImpl.this.pendingTimeouts) {
                if (now < d.getTrueEvalsStartTime() + d.getEvalTimeSetting()) continue;
                d.setSatisfied(true);
                try {
                    DbAlertsServiceImpl.this.log.debugf("Dampening Timeout Hit! %s", (Object)d.toString());
                    DbAlertsServiceImpl.this.rules.updateFact(d);
                    if (null == timeouts) {
                        timeouts = new HashSet<Dampening>();
                    }
                    timeouts.add(d);
                }
                catch (Exception e) {
                    DbAlertsServiceImpl.this.log.error((Object)("Unable to update Dampening Fact on Timeout! " + d.toString()), (Throwable)e);
                }
            }
            if (null == timeouts) {
                return 0;
            }
            DbAlertsServiceImpl.this.pendingTimeouts.removeAll(timeouts);
            return timeouts.size();
        }
    }
}

