/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ejb.Singleton;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

@Singleton
public class MemActionsServiceImpl
implements ActionsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(MemActionsServiceImpl.class);
    Queue<Action> pending = new ConcurrentLinkedDeque<Action>();
    List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();

    public MemActionsServiceImpl() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    public void send(Action action) {
        if (action == null || action.getActionId() == null || action.getActionId().isEmpty()) {
            throw new IllegalArgumentException("Action must be not null");
        }
        this.pending.add(action);
        for (ActionListener listener : this.listeners) {
            listener.process(action);
        }
    }

    public void addListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ActionListener must not be null");
        }
        this.listeners.add(listener);
        this.msgLog.infoActionListenerRegistered(listener.toString());
    }
}

