/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.rules.RulesEngine;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Singleton
public class AlertsEngineImpl
implements AlertsEngine {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(AlertsEngineImpl.class);
    private static final String ENGINE_DELAY = "hawkular-alerts.engine-delay";
    private static final String ENGINE_PERIOD = "hawkular-alerts.engine-period";
    private int delay;
    private int period;
    private final List<Data> pendingData = new ArrayList<Data>();
    private final List<Alert> alerts = new ArrayList<Alert>();
    private final Set<Dampening> pendingTimeouts = new HashSet<Dampening>();
    private final Map<Trigger, List<Set<ConditionEval>>> autoResolvedTriggers = new HashMap<Trigger, List<Set<ConditionEval>>>();
    private final Set<Trigger> disabledTriggers = new HashSet<Trigger>();
    private final Timer wakeUpTimer = new Timer("CassAlertsServiceImpl-Timer");
    private TimerTask rulesTask;
    @EJB
    RulesEngine rules;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;
    @EJB
    AlertsService alertsService;

    public AlertsEngineImpl() {
        this.delay = new Integer(AlertProperties.getProperty(ENGINE_DELAY, "1000"));
        this.period = new Integer(AlertProperties.getProperty(ENGINE_PERIOD, "2000"));
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    public DefinitionsService getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(DefinitionsService definitions) {
        this.definitions = definitions;
    }

    public ActionsService getActions() {
        return this.actions;
    }

    public void setActions(ActionsService actions) {
        this.actions = actions;
    }

    public AlertsService getAlertsService() {
        return this.alertsService;
    }

    public void setAlertsService(AlertsService alertsService) {
        this.alertsService = alertsService;
    }

    @PostConstruct
    public void initServices() {
        try {
            this.reload();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                t.printStackTrace();
            }
            this.msgLog.errorCannotInitializeAlertsService(t.getMessage());
        }
    }

    @PreDestroy
    public void shutdown() {
        this.rulesTask.cancel();
        this.wakeUpTimer.cancel();
    }

    @Override
    public void clear() {
        this.rulesTask.cancel();
        this.rules.clear();
        this.pendingData.clear();
        this.alerts.clear();
        this.pendingTimeouts.clear();
        this.autoResolvedTriggers.clear();
        this.disabledTriggers.clear();
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    @Override
    public void reload() {
        this.rules.reset();
        if (this.rulesTask != null) {
            this.rulesTask.cancel();
        }
        Collection triggers = null;
        try {
            triggers = this.definitions.getAllTriggers();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Triggers", e.getMessage());
        }
        if (triggers != null && !triggers.isEmpty()) {
            triggers.stream().filter(Trigger::isEnabled).forEach(this::reloadTrigger);
        }
        this.rules.addGlobal("log", this.log);
        this.rules.addGlobal("actions", this.actions);
        this.rules.addGlobal("alerts", this.alerts);
        this.rules.addGlobal("pendingTimeouts", this.pendingTimeouts);
        this.rules.addGlobal("autoResolvedTriggers", this.autoResolvedTriggers);
        this.rules.addGlobal("disabledTriggers", this.disabledTriggers);
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    @Override
    public void reloadTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger trigger = null;
        try {
            trigger = this.definitions.getTrigger(tenantId, triggerId);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
        }
        if (null == trigger) {
            this.log.debugf("Trigger not found for triggerId [" + triggerId + "], removing from rulebase if it exists", new Object[0]);
            Trigger doomedTrigger = new Trigger(triggerId, "doomed");
            this.removeTrigger(doomedTrigger);
            return;
        }
        this.reloadTrigger(trigger);
    }

    private void reloadTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.removeTrigger(trigger);
        if (trigger.isEnabled()) {
            try {
                Collection conditionSet = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                Collection dampenings = this.definitions.getTriggerDampenings(trigger.getTenantId(), trigger.getId(), null);
                this.rules.addFact(trigger);
                this.rules.addFacts(conditionSet);
                if (!dampenings.isEmpty()) {
                    this.rules.addFacts(dampenings);
                }
            }
            catch (Exception e) {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorDefinitionsService("Conditions/Dampening", e.getMessage());
            }
        }
    }

    @Override
    public Trigger getLoadedTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        Trigger loadedTrigger = null;
        try {
            loadedTrigger = (Trigger)this.rules.getFact(trigger);
        }
        catch (Exception e) {
            this.log.errorf("Failed to get Trigger from engine %s: %s", (Object)trigger, (Object)e);
        }
        return loadedTrigger;
    }

    private void removeTrigger(Trigger trigger) {
        if (null != this.rules.getFact(trigger)) {
            this.rules.removeFact(trigger);
            String triggerId = trigger.getId();
            this.rules.removeFacts(t -> {
                if (t instanceof Dampening) {
                    return ((Dampening)t).getTriggerId().equals(triggerId);
                }
                if (t instanceof Condition) {
                    return ((Condition)t).getTriggerId().equals(triggerId);
                }
                return false;
            });
        } else {
            this.log.debugf("Trigger not found. Not removed from rulebase %s", (Object)trigger);
        }
    }

    @Override
    public void sendData(Collection<Data> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.addPendingData(data);
    }

    @Override
    public void sendData(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.addPendingData(data);
    }

    private synchronized void addPendingData(Collection<Data> data) {
        this.pendingData.addAll(data);
    }

    private synchronized void addPendingData(Data data) {
        this.pendingData.add(data);
    }

    private synchronized Collection<Data> getAndClearPendingData() {
        ArrayList<Data> result = new ArrayList<Data>(this.pendingData);
        this.pendingData.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisabledTriggers() {
        try {
            for (Trigger t : this.disabledTriggers) {
                try {
                    t.setEnabled(false);
                    this.definitions.updateTrigger(t.getTenantId(), t);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to persist updated trigger. Could not autoDisable %s", (Object)t);
                }
            }
        }
        finally {
            this.disabledTriggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoResolvedTriggers() {
        try {
            for (Map.Entry<Trigger, List<Set<ConditionEval>>> entry : this.autoResolvedTriggers.entrySet()) {
                boolean manualReload;
                Trigger t = entry.getKey();
                boolean bl = manualReload = !t.isAutoResolveAlerts();
                if (t.isAutoResolveAlerts()) {
                    try {
                        this.alertsService.resolveAlertsForTrigger(t.getTenantId(), t.getId(), "AUTO", null, entry.getValue());
                    }
                    catch (Exception e) {
                        manualReload = true;
                        this.log.errorf("Failed to resolve Alerts. Could not AutoResolve alerts for trigger %s", (Object)t);
                    }
                }
                if (!manualReload) continue;
                try {
                    this.reloadTrigger(t.getTenantId(), t.getId());
                }
                catch (Exception e) {
                    this.log.errorf("Failed to reload AutoResolved Trigger: %s", (Object)t);
                }
            }
        }
        finally {
            this.autoResolvedTriggers.clear();
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private class RulesInvoker
    extends TimerTask {
        private RulesInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int numTimeouts = this.checkPendingTimeouts();
            if (!AlertsEngineImpl.this.pendingData.isEmpty() || numTimeouts > 0) {
                Collection newData = AlertsEngineImpl.this.getAndClearPendingData();
                AlertsEngineImpl.this.log.debugf("Executing rules engine on [%1d] datums and [%2d] dampening timeouts.", newData.size(), numTimeouts);
                try {
                    if (newData.isEmpty()) {
                        AlertsEngineImpl.this.rules.fireNoData();
                    } else {
                        AlertsEngineImpl.this.rules.addData(newData);
                        newData.clear();
                    }
                    AlertsEngineImpl.this.rules.fire();
                    AlertsEngineImpl.this.alertsService.addAlerts((Collection)AlertsEngineImpl.this.alerts);
                    AlertsEngineImpl.this.alerts.clear();
                    AlertsEngineImpl.this.handleDisabledTriggers();
                    AlertsEngineImpl.this.handleAutoResolvedTriggers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AlertsEngineImpl.this.log.debugf("Error on rules processing: " + e, new Object[0]);
                    AlertsEngineImpl.this.msgLog.errorProcessingRules(e.getMessage());
                }
                finally {
                    AlertsEngineImpl.this.alerts.clear();
                }
            }
        }

        private int checkPendingTimeouts() {
            if (AlertsEngineImpl.this.pendingTimeouts.isEmpty()) {
                return 0;
            }
            long now = System.currentTimeMillis();
            HashSet<Dampening> timeouts = null;
            for (Dampening d : AlertsEngineImpl.this.pendingTimeouts) {
                if (now < d.getTrueEvalsStartTime() + d.getEvalTimeSetting()) continue;
                d.setSatisfied(true);
                try {
                    AlertsEngineImpl.this.log.debugf("Dampening Timeout Hit! %s", (Object)d.toString());
                    AlertsEngineImpl.this.rules.updateFact(d);
                    if (null == timeouts) {
                        timeouts = new HashSet<Dampening>();
                    }
                    timeouts.add(d);
                }
                catch (Exception e) {
                    AlertsEngineImpl.this.log.error((Object)("Unable to update Dampening Fact on Timeout! " + d.toString()), (Throwable)e);
                }
            }
            if (null == timeouts) {
                return 0;
            }
            AlertsEngineImpl.this.pendingTimeouts.removeAll(timeouts);
            return timeouts.size();
        }
    }
}

