/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class EventsCacheManager {
    private final Logger log = Logger.getLogger(EventsCacheManager.class);
    Set<String> activeDataIds;
    @EJB
    DefinitionsService definitions;

    @PostConstruct
    public void init() {
        this.updateActiveIds();
        this.definitions.registerListener(new DefinitionsListener(){

            public void onChange(DefinitionsEvent event) {
                EventsCacheManager.this.updateActiveIds();
            }
        }, DefinitionsEvent.Type.CONDITION_CHANGE, new DefinitionsEvent.Type[0]);
    }

    public Set<String> getActiveDataIds() {
        return this.activeDataIds;
    }

    public void setActiveDataIds(Set<String> activeDataIds) {
        this.activeDataIds = activeDataIds;
    }

    private synchronized void updateActiveIds() {
        HashSet<String> dataIds = null;
        try {
            Collection conditions = this.definitions.getAllConditions();
            dataIds = new HashSet<String>();
            for (Condition c : conditions) {
                if (!(c instanceof EventCondition)) continue;
                dataIds.add(c.getDataId());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"FAILED to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e);
            this.activeDataIds = null;
            return;
        }
        this.activeDataIds = Collections.unmodifiableSet(dataIds);
        this.log.debugf("Updated activeDataIds! %s", this.activeDataIds);
    }
}

