/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.AlertsEngineCache;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.hawkular.alerts.engine.service.PartitionDataListener;
import org.hawkular.alerts.engine.service.PartitionManager;
import org.hawkular.alerts.engine.service.PartitionTriggerListener;
import org.hawkular.alerts.engine.service.RulesEngine;
import org.jboss.logging.Logger;

@Singleton
@Startup
@Local(value={AlertsEngine.class})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AlertsEngineImpl
implements AlertsEngine,
PartitionTriggerListener,
PartitionDataListener {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(AlertsEngineImpl.class);
    private static final String ENGINE_DELAY = "hawkular-alerts.engine-delay";
    private static final String ENGINE_PERIOD = "hawkular-alerts.engine-period";
    private int delay;
    private int period;
    private final List<Data> pendingData = new ArrayList<Data>();
    private final List<Event> pendingEvents = new ArrayList<Event>();
    private final List<Alert> alerts = new ArrayList<Alert>();
    private final List<Event> events = new ArrayList<Event>();
    private final Set<Dampening> pendingTimeouts = new HashSet<Dampening>();
    private final Map<Trigger, List<Set<ConditionEval>>> autoResolvedTriggers = new HashMap<Trigger, List<Set<ConditionEval>>>();
    private final Set<Trigger> disabledTriggers = new HashSet<Trigger>();
    private final AlertsEngineCache alertsEngineCache = new AlertsEngineCache();
    private final Timer wakeUpTimer = new Timer("CassAlertsServiceImpl-Timer");
    private TimerTask rulesTask;
    @EJB
    RulesEngine rules;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;
    @EJB
    AlertsService alertsService;
    @EJB
    PartitionManager partitionManager;
    boolean distributed = false;

    public AlertsEngineImpl() {
        this.delay = new Integer(AlertProperties.getProperty(ENGINE_DELAY, "1000"));
        this.period = new Integer(AlertProperties.getProperty(ENGINE_PERIOD, "2000"));
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    public DefinitionsService getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(DefinitionsService definitions) {
        this.definitions = definitions;
    }

    public ActionsService getActions() {
        return this.actions;
    }

    public void setActions(ActionsService actions) {
        this.actions = actions;
    }

    public AlertsService getAlertsService() {
        return this.alertsService;
    }

    public void setAlertsService(AlertsService alertsService) {
        this.alertsService = alertsService;
    }

    @PostConstruct
    public void initServices() {
        try {
            this.distributed = this.partitionManager.isDistributed();
            if (this.distributed) {
                this.log.debug((Object)"Registering PartitionManager listeners...");
                this.partitionManager.registerDataListener(this);
                this.partitionManager.registerTriggerListener(this);
            }
            this.reload();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                t.printStackTrace();
            }
            this.msgLog.errorCannotInitializeAlertsService(t.getMessage());
        }
    }

    @PreDestroy
    public void shutdown() {
        this.rulesTask.cancel();
        this.wakeUpTimer.cancel();
    }

    @Override
    public void clear() {
        this.rulesTask.cancel();
        this.rules.clear();
        this.pendingData.clear();
        this.pendingEvents.clear();
        this.alerts.clear();
        this.events.clear();
        this.pendingTimeouts.clear();
        this.autoResolvedTriggers.clear();
        this.disabledTriggers.clear();
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    @Override
    public void reload() {
        this.log.debug((Object)"Start a full reload of the AlertsEngine");
        this.rules.reset();
        this.alertsEngineCache.clear();
        if (this.rulesTask != null) {
            this.rulesTask.cancel();
        }
        Collection triggers = null;
        try {
            triggers = this.definitions.getAllTriggers();
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorDefinitionsService("Triggers", e.getMessage());
        }
        if (triggers != null && !triggers.isEmpty()) {
            triggers.stream().filter(Trigger::isLoadable).forEach(t -> {
                if (this.distributed) {
                    this.partitionManager.notifyTrigger(PartitionManager.Operation.UPDATE, t.getTenantId(), t.getId());
                } else {
                    this.reloadTrigger((Trigger)t);
                }
            });
        }
        this.rules.addGlobal("log", this.log);
        this.rules.addGlobal("actions", this.actions);
        this.rules.addGlobal("alerts", this.alerts);
        this.rules.addGlobal("events", this.events);
        this.rules.addGlobal("pendingTimeouts", this.pendingTimeouts);
        this.rules.addGlobal("autoResolvedTriggers", this.autoResolvedTriggers);
        this.rules.addGlobal("disabledTriggers", this.disabledTriggers);
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    @Override
    public void addTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.distributed) {
            Trigger trigger = null;
            try {
                trigger = this.definitions.getTrigger(tenantId, triggerId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("addTrigger(" + trigger + ")"));
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
                this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
            }
            if (trigger != null && trigger.isLoadable()) {
                this.partitionManager.notifyTrigger(PartitionManager.Operation.ADD, trigger.getTenantId(), trigger.getId());
            }
        }
    }

    @Override
    public void reloadTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger trigger = null;
        try {
            trigger = this.definitions.getTrigger(tenantId, triggerId);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
        }
        if (null == trigger) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Trigger not found for triggerId [" + triggerId + "], removing from rulebase if it exists"));
            }
            Trigger doomedTrigger = new Trigger(tenantId, triggerId, "doomed");
            this.removeTrigger(doomedTrigger);
            return;
        }
        if (!trigger.isLoadable()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Skipping reload of trigger [" + trigger.getTenantId() + "/" + trigger.getId() + "]"));
            }
            return;
        }
        if (this.distributed) {
            this.partitionManager.notifyTrigger(PartitionManager.Operation.UPDATE, trigger.getTenantId(), trigger.getId());
        } else {
            this.reloadTrigger(trigger);
        }
    }

    private void reloadTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reloading " + trigger));
        }
        this.removeTrigger(trigger);
        try {
            if (this.distributed) {
                trigger = this.definitions.getTrigger(trigger.getTenantId(), trigger.getId());
            }
            if (trigger != null && trigger.isLoadable()) {
                Collection conditionSet = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                Collection dampenings = this.definitions.getTriggerDampenings(trigger.getTenantId(), trigger.getId(), null);
                for (Condition c : conditionSet) {
                    AlertsEngineCache.DataEntry entry = new AlertsEngineCache.DataEntry(c.getTenantId(), c.getTriggerId(), c.getDataId());
                    this.alertsEngineCache.add(entry);
                    if (Condition.Type.COMPARE != c.getType()) continue;
                    String data2Id = ((CompareCondition)c).getData2Id();
                    AlertsEngineCache.DataEntry entry2 = new AlertsEngineCache.DataEntry(c.getTenantId(), c.getTriggerId(), data2Id);
                    this.alertsEngineCache.add(entry2);
                }
                this.rules.addFact(trigger);
                this.rules.addFacts(conditionSet);
                if (!dampenings.isEmpty()) {
                    this.rules.addFacts(dampenings);
                }
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorDefinitionsService("Conditions/Dampening", e.getMessage());
        }
    }

    @Override
    public Trigger getLoadedTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        Trigger loadedTrigger = null;
        try {
            loadedTrigger = (Trigger)this.rules.getFact(trigger);
        }
        catch (Exception e) {
            this.log.errorf("Failed to get Trigger from engine %s: %s", (Object)trigger, (Object)e);
        }
        return loadedTrigger;
    }

    @Override
    public void removeTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger triggerToRemove = new Trigger(tenantId, triggerId, "trigger-to-remove");
        if (this.distributed) {
            this.partitionManager.notifyTrigger(PartitionManager.Operation.REMOVE, triggerToRemove.getTenantId(), triggerToRemove.getId());
        } else {
            this.removeTrigger(triggerToRemove);
        }
    }

    private void removeTrigger(Trigger trigger) {
        if (null != this.rules.getFact(trigger)) {
            this.rules.removeFact(trigger);
            this.alertsEngineCache.remove(trigger.getTenantId(), trigger.getId());
            String triggerId = trigger.getId();
            this.rules.removeFacts(t -> {
                if (t instanceof Dampening) {
                    return ((Dampening)t).getTriggerId().equals(triggerId);
                }
                if (t instanceof Condition) {
                    return ((Condition)t).getTriggerId().equals(triggerId);
                }
                return false;
            });
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Trigger not found. Not removed from rulebase " + trigger.toString()));
        }
    }

    @Override
    public void sendData(Collection<Data> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.addPendingData(data);
        if (this.distributed) {
            this.partitionManager.notifyData(data);
        }
    }

    @Override
    public void sendData(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.addPendingData(data);
        if (this.distributed) {
            this.partitionManager.notifyData(data);
        }
    }

    @Override
    public void sendEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Event must be not null");
        }
        this.addPendingEvent(event);
        if (this.distributed) {
            this.partitionManager.notifyEvent(event);
        }
    }

    @Override
    public void sendEvents(Collection<Event> events) {
        if (events == null) {
            throw new IllegalArgumentException("Events must be not null");
        }
        this.addPendingEvents(events);
        if (this.distributed) {
            this.partitionManager.notifyEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingData(Collection<Data> data) {
        ArrayList<Data> filteredData = new ArrayList<Data>(data);
        Iterator<Data> i = filteredData.iterator();
        while (i.hasNext()) {
            Data d = i.next();
            if (this.alertsEngineCache.isDataIdActive(d.getId())) continue;
            i.remove();
        }
        List<Data> list = this.pendingData;
        synchronized (list) {
            this.pendingData.addAll(filteredData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingData(Data data) {
        if (data != null && data.getId() != null && this.alertsEngineCache.isDataIdActive(data.getId())) {
            List<Data> list = this.pendingData;
            synchronized (list) {
                this.pendingData.add(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingEvents(Collection<Event> events) {
        ArrayList<Event> filteredEvents = new ArrayList<Event>(events);
        Iterator<Event> i = filteredEvents.iterator();
        while (i.hasNext()) {
            Event e = i.next();
            if (this.alertsEngineCache.isDataIdActive(e.getDataId())) continue;
            i.remove();
        }
        List<Event> list = this.pendingEvents;
        synchronized (list) {
            this.pendingEvents.addAll(filteredEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingEvent(Event event) {
        if (event != null && event.getDataId() != null && this.alertsEngineCache.isDataIdActive(event.getDataId())) {
            List<Event> list = this.pendingEvents;
            synchronized (list) {
                this.pendingEvents.add(event);
            }
        }
    }

    private synchronized Collection<Data> getAndClearPendingData() {
        ArrayList<Data> result = new ArrayList<Data>(this.pendingData);
        this.pendingData.clear();
        return result;
    }

    private synchronized Collection<Event> getAndClearPendingEvents() {
        ArrayList<Event> result = new ArrayList<Event>(this.pendingEvents);
        this.pendingEvents.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisabledTriggers() {
        try {
            for (Trigger t : this.disabledTriggers) {
                try {
                    t.setEnabled(false);
                    this.definitions.updateTrigger(t.getTenantId(), t);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to persist updated trigger. Could not autoDisable %s", (Object)t);
                }
            }
        }
        finally {
            this.disabledTriggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoResolvedTriggers() {
        try {
            for (Map.Entry<Trigger, List<Set<ConditionEval>>> entry : this.autoResolvedTriggers.entrySet()) {
                boolean manualReload;
                Trigger t = entry.getKey();
                boolean bl = manualReload = !t.isAutoResolveAlerts();
                if (t.isAutoResolveAlerts()) {
                    try {
                        this.alertsService.resolveAlertsForTrigger(t.getTenantId(), t.getId(), "AutoResolve", "Trigger AutoResolve=True", entry.getValue());
                    }
                    catch (Exception e) {
                        manualReload = true;
                        this.log.errorf("Failed to resolve Alerts. Could not AutoResolve alerts for trigger %s", (Object)t);
                    }
                }
                if (!manualReload) continue;
                try {
                    this.reloadTrigger(t.getTenantId(), t.getId());
                }
                catch (Exception e) {
                    this.log.errorf("Failed to reload AutoResolved Trigger: %s", (Object)t);
                }
            }
        }
        finally {
            this.autoResolvedTriggers.clear();
        }
    }

    @Override
    public void onNewData(Data data) {
        this.addPendingData(data);
    }

    @Override
    public void onNewData(Collection<Data> data) {
        this.addPendingData(data);
    }

    @Override
    public void onNewEvent(Event event) {
        this.addPendingEvent(event);
    }

    @Override
    public void onNewEvents(Collection<Event> events) {
        this.addPendingEvents(events);
    }

    @Override
    public void onTriggerChange(PartitionManager.Operation operation, String tenantId, String triggerId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Executing: " + (Object)((Object)operation) + " tenantId: " + tenantId + " triggerId: " + triggerId));
        }
        switch (operation) {
            case ADD: 
            case UPDATE: {
                Trigger reloadTrigger = new Trigger(tenantId, triggerId, "reload-trigger");
                this.reloadTrigger(reloadTrigger);
                break;
            }
            case REMOVE: {
                Trigger removeTrigger = new Trigger(tenantId, triggerId, "remove-trigger");
                this.removeTrigger(removeTrigger);
            }
        }
    }

    @Override
    public void onPartitionChange(Map<String, List<String>> partition, Map<String, List<String>> removed, Map<String, List<String>> added) {
        String tenantId;
        if (!this.pendingData.isEmpty() || !this.pendingEvents.isEmpty()) {
            if (!this.pendingData.isEmpty()) {
                this.log.warn((Object)("Pending Data onPartitionChange: " + this.pendingData));
            }
            if (this.pendingEvents.isEmpty()) {
                this.log.warn((Object)("Pending Events onPartitionChange: " + this.pendingData));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Executing: PartitionChange ");
            this.log.debug((Object)("Local partition: " + partition));
            this.log.debug((Object)("Removed: " + removed));
            this.log.debug((Object)("Added: " + added));
        }
        for (Map.Entry<String, List<String>> entry : removed.entrySet()) {
            tenantId = entry.getKey();
            entry.getValue().stream().forEach(triggerId -> {
                Trigger removeTrigger = new Trigger(tenantId, triggerId, "to-remove-from-alerts-engine");
                this.removeTrigger(removeTrigger);
            });
        }
        for (Map.Entry<String, List<String>> entry : added.entrySet()) {
            tenantId = entry.getKey();
            entry.getValue().stream().forEach(triggerId -> this.reloadTrigger(tenantId, (String)triggerId));
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private class RulesInvoker
    extends TimerTask {
        private RulesInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int numTimeouts = this.checkPendingTimeouts();
            if (!AlertsEngineImpl.this.pendingData.isEmpty() || !AlertsEngineImpl.this.pendingEvents.isEmpty() || numTimeouts > 0) {
                Collection newData = AlertsEngineImpl.this.getAndClearPendingData();
                Collection newEvents = AlertsEngineImpl.this.getAndClearPendingEvents();
                if (AlertsEngineImpl.this.log.isDebugEnabled()) {
                    AlertsEngineImpl.this.log.debug((Object)("Executing rules engine on " + newData.size() + " datums, " + newEvents.size() + " events and " + numTimeouts + " dampening timeouts."));
                }
                try {
                    if (newData.isEmpty() && newEvents.isEmpty()) {
                        AlertsEngineImpl.this.rules.fireNoData();
                    } else {
                        if (!newData.isEmpty()) {
                            AlertsEngineImpl.this.rules.addData(newData);
                            newData.clear();
                        }
                        if (!newEvents.isEmpty()) {
                            AlertsEngineImpl.this.rules.addEvents(newEvents);
                            newEvents.clear();
                        }
                    }
                    AlertsEngineImpl.this.rules.fire();
                    AlertsEngineImpl.this.alertsService.addAlerts((Collection)AlertsEngineImpl.this.alerts);
                    AlertsEngineImpl.this.alerts.clear();
                    AlertsEngineImpl.this.alertsService.persistEvents((Collection)AlertsEngineImpl.this.events);
                    if (AlertsEngineImpl.this.distributed) {
                        AlertsEngineImpl.this.partitionManager.notifyEvents(AlertsEngineImpl.this.events);
                    }
                    AlertsEngineImpl.this.events.clear();
                    AlertsEngineImpl.this.handleDisabledTriggers();
                    AlertsEngineImpl.this.handleAutoResolvedTriggers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (AlertsEngineImpl.this.log.isDebugEnabled()) {
                        AlertsEngineImpl.this.log.debug((Object)("Error on rules processing: " + e));
                    }
                    AlertsEngineImpl.this.msgLog.errorProcessingRules(e.getMessage());
                }
                finally {
                    AlertsEngineImpl.this.alerts.clear();
                    AlertsEngineImpl.this.events.clear();
                }
            }
        }

        private int checkPendingTimeouts() {
            if (AlertsEngineImpl.this.pendingTimeouts.isEmpty()) {
                return 0;
            }
            long now = System.currentTimeMillis();
            HashSet<Dampening> timeouts = null;
            for (Dampening d : AlertsEngineImpl.this.pendingTimeouts) {
                if (now < d.getTrueEvalsStartTime() + d.getEvalTimeSetting()) continue;
                d.setSatisfied(true);
                try {
                    if (AlertsEngineImpl.this.log.isDebugEnabled()) {
                        AlertsEngineImpl.this.log.debug((Object)("Dampening Timeout Hit! " + d.toString()));
                    }
                    AlertsEngineImpl.this.rules.updateFact(d);
                    if (null == timeouts) {
                        timeouts = new HashSet<Dampening>();
                    }
                    timeouts.add(d);
                }
                catch (Exception e) {
                    AlertsEngineImpl.this.log.error((Object)("Unable to update Dampening Fact on Timeout! " + d.toString()), (Throwable)e);
                }
            }
            if (null == timeouts) {
                return 0;
            }
            AlertsEngineImpl.this.pendingTimeouts.removeAll(timeouts);
            return timeouts.size();
        }
    }
}

