/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class AlertsContext {
    private final Logger log = Logger.getLogger(AlertsContext.class);
    private boolean initialized = false;
    private Map<DefinitionsListener, Set<DefinitionsEvent.Type>> definitionListeners = new HashMap<DefinitionsListener, Set<DefinitionsEvent.Type>>();
    List<ActionListener> actionsListeners = new CopyOnWriteArrayList<ActionListener>();

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialized(boolean initialized) {
        AlertsContext alertsContext = this;
        synchronized (alertsContext) {
            this.initialized = initialized;
        }
    }

    public void registerDefinitionListener(DefinitionsListener listener, DefinitionsEvent.Type eventType, DefinitionsEvent.Type ... eventTypes) {
        EnumSet<DefinitionsEvent.Type[]> types = EnumSet.of(eventType, eventTypes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering listeners " + listener + " for event types " + types));
        }
        this.definitionListeners.put(listener, types);
    }

    public Map<DefinitionsListener, Set<DefinitionsEvent.Type>> getDefinitionListeners() {
        return this.definitionListeners;
    }

    public void registerActionListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ActionListener must not be null");
        }
        this.actionsListeners.add(listener);
    }

    public List<ActionListener> getActionsListeners() {
        return this.actionsListeners;
    }
}

