/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerType;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DataDrivenGroupCacheManager {
    private final Logger log = Logger.getLogger(DataDrivenGroupCacheManager.class);
    Map<CacheKey, Set<String>> sourcesMap = new HashMap<CacheKey, Set<String>>();
    Map<CacheKey, Set<String>> triggersMap = new HashMap<CacheKey, Set<String>>();
    @EJB
    DefinitionsService definitions;

    @PostConstruct
    public void init() {
        this.updateCache();
        this.definitions.registerListener(new DefinitionsListener(){

            public void onChange(DefinitionsEvent event) {
                DataDrivenGroupCacheManager.this.updateCache();
            }
        }, DefinitionsEvent.Type.CONDITION_CHANGE, new DefinitionsEvent.Type[0]);
    }

    private synchronized void updateCache() {
        try {
            Collection allTriggers = this.definitions.getAllTriggers();
            HashSet<Trigger> ddGroupTriggers = new HashSet<Trigger>();
            for (Trigger t : allTriggers) {
                if (TriggerType.DATA_DRIVEN_GROUP != t.getType()) continue;
                ddGroupTriggers.add(t);
            }
            HashSet conditions = new HashSet();
            for (Trigger groupTrigger : ddGroupTriggers) {
                String tenantId = groupTrigger.getTenantId();
                HashSet<String> sources = new HashSet<String>();
                for (Trigger memberTrigger : this.definitions.getMemberTriggers(tenantId, groupTrigger.getId(), false)) {
                    sources.add(memberTrigger.getSource());
                }
                for (Condition c : this.definitions.getTriggerConditions(tenantId, groupTrigger.getId(), null)) {
                    CacheKey key = new CacheKey(tenantId, c.getDataId());
                    this.sourcesMap.put(key, sources);
                    Set<String> triggers = this.triggersMap.get(key);
                    if (null == triggers) {
                        triggers = new HashSet<String>();
                    }
                    triggers.add(groupTrigger.getId());
                    this.triggersMap.put(key, triggers);
                    if (!(c instanceof CompareCondition)) continue;
                    key = new CacheKey(tenantId, ((CompareCondition)c).getData2Id());
                    this.sourcesMap.put(key, sources);
                    triggers = this.triggersMap.get(key);
                    if (null == triggers) {
                        triggers = new HashSet<String>();
                    }
                    triggers.add(groupTrigger.getId());
                    this.triggersMap.put(key, triggers);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"FAILED to updateCache. Unable to generate data-driven member triggers!", (Throwable)e);
            this.sourcesMap = new HashMap<CacheKey, Set<String>>();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updated sourceMap! " + this.sourcesMap));
        }
    }

    public boolean isCacheActive() {
        return !this.sourcesMap.isEmpty();
    }

    public Set<String> needsSourceMember(String tenantId, String dataId, String source) {
        if (this.isEmpty(source, dataId, tenantId) || "_none_".equals(source)) {
            return Collections.EMPTY_SET;
        }
        CacheKey key = new CacheKey(tenantId, dataId);
        if (null == this.triggersMap.get(key)) {
            return Collections.EMPTY_SET;
        }
        Set<String> sources = this.sourcesMap.get(key);
        if (sources.contains(source)) {
            return Collections.EMPTY_SET;
        }
        return this.triggersMap.get(key);
    }

    private boolean isEmpty(String ... strings) {
        for (String s : strings) {
            if (null != s && !s.trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class CacheKey {
        private String tenantId;
        private String dataId;

        public CacheKey(String tenantId, String dataId) {
            this.tenantId = tenantId;
            this.dataId = dataId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
            result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
                return false;
            }
            return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
        }

        public String toString() {
            return "CacheKey [" + this.tenantId + ":" + this.dataId + "]";
        }
    }
}

