/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.util;

import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.TriggerAction;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

public class ActionsValidator {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(ActionsValidator.class);

    public static boolean validate(TriggerAction triggerAction, Event event) {
        if (triggerAction == null || event == null) {
            return true;
        }
        if ((triggerAction.getStates() == null || triggerAction.getStates().isEmpty()) && triggerAction.getCalendar() == null) {
            return true;
        }
        if (event instanceof Alert && triggerAction.getStates() != null && !triggerAction.getStates().isEmpty() && !triggerAction.getStates().contains(((Alert)event).getStatus().name())) {
            return false;
        }
        if (triggerAction.getCalendar() != null) {
            try {
                return triggerAction.getCalendar().isSatisfiedBy(event.getCtime());
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                msgLog.errorCannotValidateAction(e.getMessage());
            }
        }
        return true;
    }
}

