/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.AccessTimeout;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.inject.Produces;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassClusterSession;
import org.hawkular.alerts.engine.impl.CassDefinitionsServiceImpl;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class CassCluster {
    private static final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private static final String ALERTS_CASSANDRA_PORT = "hawkular-alerts.cassandra-cql-port";
    private static final String ALERTS_CASSANDRA_PORT_ENV = "CASSANDRA_CQL_PORT";
    private static final String ALERTS_CASSANDRA_NODES = "hawkular-alerts.cassandra-nodes";
    private static final String ALERTS_CASSANDRA_NODES_ENV = "CASSANDRA_NODES";
    private static final String ALERTS_CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private static final String ALERTS_CASSANDRA_RETRY_ATTEMPTS = "hawkular-alerts.cassandra-retry-attempts";
    private static final String ALERTS_CASSANDRA_RETRY_TIMEOUT = "hawkular-alerts.cassandra-retry-timeout";
    private static final String ALERTS_CASSANDRA_CONNECT_TIMEOUT = "hawkular-alerts.cassandra-connect-timeout";
    private static final String ALERTS_CASSANDRA_CONNECT_TIMEOUT_ENV = "CASSANDRA_CONNECT_TIMEOUT";
    private static final String ALERTS_CASSANDRA_READ_TIMEOUT = "hawkular-alerts.cassandra-read-timeout";
    private static final String ALERTS_CASSANDRA_READ_TIMEOUT_ENV = "CASSANDRA_READ_TIMEOUT";
    private static final String ALERTS_CASSANDRA_OVERWRITE = "hawkular-alerts.cassandra-overwrite";
    private static final String ALERTS_CASSANDRA_OVERWRITE_ENV = "CASSANDRA_OVERWRITE";
    private int attempts;
    private int timeout;
    private String cqlPort;
    private String nodes;
    private int connTimeout;
    private int readTimeout;
    private boolean overwrite = false;
    private Cluster cluster = null;
    private Session session = null;
    private boolean initialized = false;

    private void readProperties() {
        this.attempts = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_ATTEMPTS, "5"));
        this.timeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_TIMEOUT, "2000"));
        this.cqlPort = AlertProperties.getProperty(ALERTS_CASSANDRA_PORT, ALERTS_CASSANDRA_PORT_ENV, "9042");
        this.nodes = AlertProperties.getProperty(ALERTS_CASSANDRA_NODES, ALERTS_CASSANDRA_NODES_ENV, "127.0.0.1");
        this.connTimeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_CONNECT_TIMEOUT, ALERTS_CASSANDRA_CONNECT_TIMEOUT_ENV, String.valueOf(5000)));
        this.readTimeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_READ_TIMEOUT, ALERTS_CASSANDRA_READ_TIMEOUT_ENV, String.valueOf(12000)));
        this.overwrite = Boolean.parseBoolean(AlertProperties.getProperty(ALERTS_CASSANDRA_OVERWRITE, ALERTS_CASSANDRA_OVERWRITE_ENV, "false"));
    }

    @PostConstruct
    public void initCassCluster() {
        this.readProperties();
        if (this.cluster == null && this.session == null) {
            int currentAttempts = this.attempts;
            while (this.session == null && !Thread.currentThread().isInterrupted() && currentAttempts >= 0) {
                block15: {
                    try {
                        SocketOptions socketOptions = null;
                        if (this.connTimeout != 5000 || this.readTimeout != 12000) {
                            socketOptions = new SocketOptions();
                            if (this.connTimeout != 5000) {
                                socketOptions.setConnectTimeoutMillis(this.connTimeout);
                            }
                            if (this.readTimeout != 12000) {
                                socketOptions.setReadTimeoutMillis(this.readTimeout);
                            }
                        }
                        Cluster.Builder clusterBuilder = new Cluster.Builder().addContactPoints(this.nodes.split(",")).withPort(new Integer(this.cqlPort).intValue()).withProtocolVersion(ProtocolVersion.V3).withQueryOptions(new QueryOptions().setRefreshSchemaIntervalMillis(0));
                        if (socketOptions != null) {
                            clusterBuilder.withSocketOptions(socketOptions);
                        }
                        this.cluster = clusterBuilder.build();
                        this.session = this.cluster.connect();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Could not connect to Cassandra cluster - assuming is not up yet. Cause: " + (e.getCause() == null ? e : e.getCause())));
                        if (this.attempts != 0) break block15;
                        throw e;
                    }
                }
                if (this.session != null) continue;
                log.warn((Object)("[" + currentAttempts + "] Retrying connecting to Cassandra cluster in [" + this.timeout + "]ms..."));
                --currentAttempts;
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.session != null && !this.initialized) {
                String keyspace = AlertProperties.getProperty(ALERTS_CASSANDRA_KEYSPACE, "hawkular_alerts");
                try {
                    this.initScheme(this.session, keyspace, this.overwrite);
                }
                catch (IOException e) {
                    log.error((Object)"Error on initialization of Alerts scheme", (Throwable)e);
                }
            }
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.session != null && !this.initialized) {
            throw new RuntimeException("Cassandra alerts keyspace is not initialized");
        }
    }

    private void initScheme(Session session, String keyspace, boolean overwrite) throws IOException {
        KeyspaceMetadata keyspaceMetadata;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking Schema existence for keyspace: " + keyspace));
        }
        if ((keyspaceMetadata = this.cluster.getMetadata().getKeyspace(keyspace)) != null) {
            if (overwrite) {
                session.execute("DROP KEYSPACE " + keyspace);
            } else {
                int currentAttempts = this.attempts;
                while (!this.checkSchema(keyspace) && !Thread.currentThread().isInterrupted() && currentAttempts >= 0) {
                    log.warn((Object)("[" + currentAttempts + "] Keyspace detected but schema not fully created. Retrying in [" + this.timeout + "]ms..."));
                    --currentAttempts;
                    try {
                        Thread.sleep(this.timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!this.checkSchema(keyspace)) {
                    log.errorf("Keyspace detected, but failed on check phase.", (Object)keyspace);
                    return;
                }
                log.debug((Object)"Schema already exist. Skipping schema creation.");
                this.initialized = true;
                return;
            }
        }
        log.infof("Creating Schema for keyspace %s", (Object)keyspace);
        ImmutableMap schemaVars = ImmutableMap.of((Object)"keyspace", (Object)keyspace);
        String updatedCQL = null;
        try (InputStream isSchema = CassCluster.class.getResourceAsStream("/hawkular-alerts-schema.cql");
             InputStreamReader readerSchema = new InputStreamReader(isSchema);){
            String content = CharStreams.toString((Readable)readerSchema);
            for (String cql : content.split("(?m)^-- #.*$")) {
                if (cql.startsWith("--")) continue;
                updatedCQL = this.substituteVars(cql.trim(), (Map<String, String>)schemaVars);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing CQL:\n" + updatedCQL + "\n"));
                }
                session.execute(updatedCQL);
            }
        }
        catch (Exception e) {
            log.errorf("Failed schema creation: %s\nEXECUTING CQL:\n%s", (Object)e, updatedCQL);
        }
        this.initialized = true;
        log.infof("Done creating Schema for keyspace: " + keyspace, new Object[0]);
    }

    /*
     * Exception decompiling
     */
    private boolean checkSchema(String keyspace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String substituteVars(String cql, Map<String, String> vars) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Produces
    @AccessTimeout(value=300L, unit=TimeUnit.SECONDS)
    @CassClusterSession
    public Session getSession() {
        return this.session;
    }

    @PreDestroy
    public void shutdown() {
        log.info((Object)"Closing Cassandra cluster session");
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
        }
    }
}

