/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.filter.CacheKey;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.jboss.logging.Logger;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CacheManager {
    private final Logger log = Logger.getLogger(CacheManager.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String DISABLE_PUBLISH_FILTERING_PROP = "hawkular-alerts.disable-publish-filtering";
    private static final String DISABLE_PUBLISH_FILTERING_ENV = "DISABLE_PUBLISH_FILTERING";
    private static final String RESET_PUBLISH_CACHE_PROP = "hawkular-alerts.reset-publish-cache";
    private static final String RESET_PUBLISH_CACHE_ENV = "RESET_PUBLISH_CACHE";
    private volatile boolean updateRequested = false;
    private volatile boolean updating = false;
    @EJB
    PropertiesService properties;
    @EJB
    DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/publish")
    private Cache<CacheKey, String> publishCache;

    @PostConstruct
    public void init() {
        boolean disablePublish = Boolean.parseBoolean(this.properties.getProperty(DISABLE_PUBLISH_FILTERING_PROP, DISABLE_PUBLISH_FILTERING_ENV, "false"));
        boolean resetCache = Boolean.parseBoolean(this.properties.getProperty(RESET_PUBLISH_CACHE_PROP, RESET_PUBLISH_CACHE_ENV, "true"));
        if (!disablePublish) {
            if (resetCache) {
                this.msgLog.warnClearPublishCache();
                this.publishCache.clear();
            }
            this.msgLog.infoInitPublishCache();
            this.requestCacheUpdate();
            this.definitions.registerListener(e -> this.requestCacheUpdate(), DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        } else {
            this.msgLog.warnDisabledPublishCache();
        }
    }

    private void requestCacheUpdate() {
        this.log.debug((Object)"Cache update requested");
        if (this.updateRequested) {
            this.log.debug((Object)"Cache update, redundant request ignored.");
            return;
        }
        this.updateRequested = true;
        if (!this.updating) {
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCache() {
        try {
            this.updating = true;
            while (this.updateRequested) {
                this.updateRequested = false;
                this.log.debug((Object)"Cache update in progress..");
                CacheSet currentlyPublished = this.publishCache.keySet();
                this.log.debugf("Published before update=%s", currentlyPublished.size());
                if (this.log.isTraceEnabled()) {
                    this.publishCache.entrySet().stream().forEach(e -> this.log.tracef("Published: %s", e.getValue()));
                }
                Collection conditions = this.definitions.getAllConditions();
                HashSet<CacheKey> activeKeys = new HashSet<CacheKey>();
                for (Condition c : conditions) {
                    CacheKey cacheKey = new CacheKey(c.getTenantId(), c.getDataId());
                    if (!activeKeys.contains(cacheKey)) {
                        activeKeys.add(cacheKey);
                        if (!currentlyPublished.contains((Object)cacheKey)) {
                            this.publish(cacheKey);
                        }
                    }
                    if (!(c instanceof CompareCondition)) continue;
                    String data2Id = ((CompareCondition)c).getData2Id();
                    CacheKey cacheKey2 = new CacheKey(c.getTenantId(), data2Id);
                    if (activeKeys.contains(cacheKey2)) continue;
                    activeKeys.add(cacheKey2);
                    if (currentlyPublished.contains((Object)cacheKey2)) continue;
                    this.publish(cacheKey2);
                }
                HashSet<CacheKey> doomedKeys = new HashSet<CacheKey>();
                if (!currentlyPublished.isEmpty()) {
                    currentlyPublished.stream().filter(k -> !activeKeys.contains(k)).forEach(k -> doomedKeys.add((CacheKey)k));
                }
                this.unpublish(doomedKeys);
                this.log.debugf("Published after update=%s", this.publishCache.size());
                if (!this.log.isTraceEnabled()) continue;
                this.publishCache.entrySet().stream().forEach(e -> this.log.tracef("Published: %s", e.getValue()));
            }
        }
        catch (Exception e2) {
            this.log.error((Object)"Failed to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e2);
            return;
        }
        finally {
            this.log.debug((Object)"Cache updates complete.");
            this.updating = false;
        }
    }

    private void publish(CacheKey cacheKey) {
        if (cacheKey != null && this.publishCache != null) {
            this.log.debugf("Publishing:%s ", (Object)cacheKey);
            this.publishCache.put((Object)cacheKey, (Object)"");
        }
    }

    private void unpublish(Set<CacheKey> cacheKeys) {
        for (CacheKey cacheKey : cacheKeys) {
            if (cacheKey == null || this.publishCache == null) continue;
            this.log.debugf("UN-Publishing:%s ", (Object)cacheKey);
            this.publishCache.remove((Object)cacheKey);
        }
    }
}

