/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerType;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.jboss.logging.Logger;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DataDrivenGroupCacheManager {
    private final Logger log = Logger.getLogger(DataDrivenGroupCacheManager.class);
    private static final String DATA_DRIVEN_TRIGGERS_ENABLED = "hawkular-alerts.data-driven-triggers-enabled";
    private static final String DATA_DRIVEN_TRIGGERS_ENABLED_DEFAULT = "true";
    private boolean dataDrivenTriggersEnabled;
    Map<CacheKey, Set<String>> sourcesMap = new HashMap<CacheKey, Set<String>>();
    Map<CacheKey, Set<String>> triggersMap = new HashMap<CacheKey, Set<String>>();
    private volatile boolean updateRequested = false;
    private volatile boolean updating = false;
    @EJB
    DefinitionsService definitions;

    @PostConstruct
    public void init() {
        this.dataDrivenTriggersEnabled = new Boolean(AlertProperties.getProperty(DATA_DRIVEN_TRIGGERS_ENABLED, DATA_DRIVEN_TRIGGERS_ENABLED_DEFAULT));
        this.log.infof("Data-driven Group Triggers enabled: %s", (Object)this.dataDrivenTriggersEnabled);
        if (this.dataDrivenTriggersEnabled) {
            this.requestCacheUpdate();
            this.definitions.registerListener(new DefinitionsListener(){

                public void onChange(DefinitionsEvent event) {
                    DataDrivenGroupCacheManager.this.requestCacheUpdate();
                }
            }, DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[0]);
        }
    }

    private void requestCacheUpdate() {
        this.log.debug((Object)"Cache update requested");
        if (this.updateRequested) {
            this.log.debug((Object)"Cache update, redundant request ignored.");
            return;
        }
        this.updateRequested = true;
        if (!this.updating) {
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AccessTimeout(value=5L, unit=TimeUnit.MINUTES)
    private synchronized void updateCache() {
        this.log.debug((Object)"Updating cache...");
        try {
            this.updating = true;
            while (this.updateRequested) {
                this.updateRequested = false;
                this.log.debug((Object)"Cache update in progress..");
                Collection allTriggers = this.definitions.getAllTriggers();
                HashSet<Trigger> ddGroupTriggers = new HashSet<Trigger>();
                for (Trigger t : allTriggers) {
                    if (TriggerType.DATA_DRIVEN_GROUP != t.getType()) continue;
                    ddGroupTriggers.add(t);
                }
                this.log.debugf("Updating [%d] data-driven triggers out of [%d] total triggers...", ddGroupTriggers.size(), allTriggers.size());
                for (Trigger groupTrigger : ddGroupTriggers) {
                    String tenantId = groupTrigger.getTenantId();
                    HashSet<String> sources = new HashSet<String>();
                    for (Trigger memberTrigger : this.definitions.getMemberTriggers(tenantId, groupTrigger.getId(), false)) {
                        sources.add(memberTrigger.getSource());
                    }
                    for (Condition c : this.definitions.getTriggerConditions(tenantId, groupTrigger.getId(), null)) {
                        CacheKey key = new CacheKey(tenantId, c.getDataId());
                        this.sourcesMap.put(key, sources);
                        Set<String> triggers = this.triggersMap.get(key);
                        if (null == triggers) {
                            triggers = new HashSet<String>();
                        }
                        triggers.add(groupTrigger.getId());
                        this.triggersMap.put(key, triggers);
                        if (!(c instanceof CompareCondition)) continue;
                        key = new CacheKey(tenantId, ((CompareCondition)c).getData2Id());
                        this.sourcesMap.put(key, sources);
                        triggers = this.triggersMap.get(key);
                        if (null == triggers) {
                            triggers = new HashSet<String>();
                        }
                        triggers.add(groupTrigger.getId());
                        this.triggersMap.put(key, triggers);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"FAILED to updateCache. Unable to generate data-driven member triggers!", (Throwable)e);
            this.sourcesMap = new HashMap<CacheKey, Set<String>>();
        }
        finally {
            this.log.debugf("Cache updates complete. sourceMap: %s", this.sourcesMap);
            this.updating = false;
        }
    }

    @Lock(value=LockType.READ)
    public boolean isCacheActive() {
        return !this.sourcesMap.isEmpty();
    }

    @Lock(value=LockType.READ)
    public Set<String> needsSourceMember(String tenantId, String dataId, String source) {
        if (this.isEmpty(source, dataId, tenantId) || "_none_".equals(source)) {
            return Collections.emptySet();
        }
        CacheKey key = new CacheKey(tenantId, dataId);
        if (null == this.triggersMap.get(key)) {
            return Collections.emptySet();
        }
        Set<String> sources = this.sourcesMap.get(key);
        if (sources.contains(source)) {
            return Collections.emptySet();
        }
        return this.triggersMap.get(key);
    }

    private boolean isEmpty(String ... strings) {
        for (String s : strings) {
            if (null != s && !s.trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class CacheKey {
        private String tenantId;
        private String dataId;

        public CacheKey(String tenantId, String dataId) {
            this.tenantId = tenantId;
            this.dataId = dataId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
            result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
                return false;
            }
            return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
        }

        public String toString() {
            return "CacheKey [" + this.tenantId + ":" + this.dataId + "]";
        }
    }
}

