/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.filter.CacheKey;
import org.infinispan.Cache;
import org.jboss.logging.Logger;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PublishCacheManager {
    private final Logger log = Logger.getLogger(PublishCacheManager.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String DISABLE_PUBLISH_FILTERING_PROP = "hawkular-alerts.disable-publish-filtering";
    private static final String DISABLE_PUBLISH_FILTERING_ENV = "DISABLE_PUBLISH_FILTERING";
    private static final String RESET_PUBLISH_CACHE_PROP = "hawkular-alerts.reset-publish-cache";
    private static final String RESET_PUBLISH_CACHE_ENV = "RESET_PUBLISH_CACHE";
    @EJB
    PropertiesService properties;
    @EJB
    DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/dataIds")
    private Cache<TriggerKey, Set<String>> publishDataIdsCache;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/publish")
    private Cache<CacheKey, Set<String>> publishCache;

    @PostConstruct
    public void init() {
        boolean disablePublish = Boolean.parseBoolean(this.properties.getProperty(DISABLE_PUBLISH_FILTERING_PROP, DISABLE_PUBLISH_FILTERING_ENV, "false"));
        boolean resetCache = Boolean.parseBoolean(this.properties.getProperty(RESET_PUBLISH_CACHE_PROP, RESET_PUBLISH_CACHE_ENV, "true"));
        if (!disablePublish) {
            if (resetCache) {
                this.msgLog.warnClearPublishCache();
                this.publishCache.clear();
                this.publishDataIdsCache.clear();
            }
            this.msgLog.infoInitPublishCache();
            this.initialCacheUpdate();
            this.definitions.registerListener(events -> events.stream().forEach(e -> {
                String tenantId = e.getTargetTenantId();
                String triggerId = e.getTargetId();
                TriggerKey triggerKey = new TriggerKey(tenantId, triggerId);
                this.publishCache.startBatch();
                this.publishDataIdsCache.startBatch();
                Set oldDataIds = (Set)this.publishDataIdsCache.get((Object)triggerKey);
                this.removePublishCache(tenantId, triggerId, oldDataIds);
                if (e.getType().equals((Object)DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE)) {
                    Set newDataIds = e.getDataIds();
                    this.publishDataIdsCache.put((Object)triggerKey, (Object)newDataIds);
                    this.addPublishCache(tenantId, triggerId, newDataIds);
                }
                this.publishDataIdsCache.endBatch(true);
                this.publishCache.endBatch(true);
            }), DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        } else {
            this.msgLog.warnDisabledPublishCache();
        }
    }

    private void removePublishCache(String tenantId, String triggerId, Set<String> dataIds) {
        if (!this.isEmpty(dataIds)) {
            dataIds.stream().forEach(dataId -> {
                CacheKey cacheKey = new CacheKey(tenantId, dataId);
                Set triggerIds = (Set)this.publishCache.get((Object)cacheKey);
                if (!this.isEmpty(triggerIds)) {
                    triggerIds.remove(triggerId);
                    if (triggerIds.isEmpty()) {
                        this.publishCache.remove((Object)cacheKey);
                    } else {
                        this.publishCache.put((Object)cacheKey, (Object)triggerIds);
                    }
                }
            });
        }
    }

    private void addPublishCache(String tenantId, String triggerId, Set<String> dataIds) {
        if (!this.isEmpty(dataIds)) {
            dataIds.stream().forEach(dataId -> {
                CacheKey cacheKey = new CacheKey(tenantId, dataId);
                HashSet<String> triggerIds = (HashSet<String>)this.publishCache.get((Object)cacheKey);
                if (triggerIds == null) {
                    triggerIds = new HashSet<String>();
                }
                triggerIds.add(triggerId);
                this.publishCache.put((Object)cacheKey, triggerIds);
            });
        }
    }

    private void initialCacheUpdate() {
        try {
            this.log.debug((Object)"Initial PublishCacheManager update in progress..");
            this.publishCache.startBatch();
            this.publishDataIdsCache.startBatch();
            Collection conditions = this.definitions.getAllConditions();
            for (Condition c : conditions) {
                HashSet<String> prevDataIds;
                String triggerId = c.getTriggerId();
                TriggerKey triggerKey = new TriggerKey(c.getTenantId(), triggerId);
                HashSet<String> dataIds = new HashSet<String>();
                dataIds.add(c.getDataId());
                if (c instanceof CompareCondition) {
                    String data2Id = ((CompareCondition)c).getData2Id();
                    dataIds.add(data2Id);
                }
                if ((prevDataIds = (HashSet<String>)this.publishDataIdsCache.get((Object)triggerKey)) == null) {
                    prevDataIds = new HashSet<String>();
                }
                prevDataIds.addAll(dataIds);
                this.publishDataIdsCache.put((Object)triggerKey, prevDataIds);
                this.addPublishCache(c.getTenantId(), triggerId, dataIds);
            }
            this.log.debugf("Published after update=%s", this.publishCache.size());
            if (this.log.isTraceEnabled()) {
                this.publishCache.entrySet().stream().forEach(e -> this.log.tracef("Published: %s", e.getValue()));
            }
            this.publishDataIdsCache.endBatch(true);
            this.publishCache.endBatch(true);
        }
        catch (Exception e2) {
            this.log.error((Object)"Failed to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e2);
            this.publishDataIdsCache.endBatch(false);
            this.publishCache.endBatch(false);
            return;
        }
    }

    private boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static class TriggerKey
    implements Serializable {
        private String tenantId;
        private String triggerId;

        public TriggerKey(String tenantId, String triggerId) {
            this.tenantId = tenantId;
            this.triggerId = triggerId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerKey that = (TriggerKey)o;
            if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
                return false;
            }
            return this.triggerId != null ? this.triggerId.equals(that.triggerId) : that.triggerId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TriggerKey{tenantId='" + this.tenantId + '\'' + ", triggerId='" + this.triggerId + '\'' + '}';
        }
    }
}

