/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.DataDrivenGroupCacheManager;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.hawkular.alerts.engine.service.IncomingDataManager;
import org.hawkular.alerts.engine.service.PartitionManager;
import org.hawkular.alerts.filter.CacheClient;
import org.jboss.logging.Logger;

@Singleton
@Startup
@Local(value={IncomingDataManager.class})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class IncomingDataManagerImpl
implements IncomingDataManager {
    private final Logger log = Logger.getLogger(IncomingDataManagerImpl.class);
    private int minReportingIntervalData;
    private int minReportingIntervalEvents;
    @Resource
    private ManagedExecutorService executor;
    @EJB
    DataDrivenGroupCacheManager dataDrivenGroupCacheManager;
    @EJB
    DefinitionsService definitionsService;
    @EJB
    PartitionManager partitionManager;
    @EJB
    AlertsEngine alertsEngine;
    @Inject
    CacheClient dataIdCache;

    @PostConstruct
    public void init() {
        try {
            this.minReportingIntervalData = new Integer(AlertProperties.getProperty("hawkular-alerts.min-reporting-interval-data", "HAWKULAR_MIN_REPORTING_INTERVAL_DATA", "1000"));
            this.minReportingIntervalEvents = new Integer(AlertProperties.getProperty("hawkular-alerts.min-reporting-interval-events", "HAWKULAR_MIN_REPORTING_INTERVAL_EVENTS", "0"));
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                t.printStackTrace();
            }
            this.log.errorf("Failed to initialize: %s", (Object)t.getMessage());
        }
    }

    @Override
    public void bufferData(IncomingData incomingData) {
        this.executor.submit(() -> this.processData(incomingData));
    }

    @Override
    public void bufferEvents(IncomingEvents incomingEvents) {
        this.executor.submit(() -> this.processEvents(incomingEvents));
    }

    private void processData(IncomingData incomingData) {
        this.log.debugf("Processing [%d] datums for AlertsEngine.", incomingData.incomingData.size());
        TreeSet<Data> filteredData = new TreeSet<Data>(this.filterIncomingData(incomingData));
        this.enforceMinReportingInterval(filteredData);
        this.checkDataDrivenGroupTriggers(filteredData);
        try {
            this.log.debugf("Sending [%d] datums to AlertsEngine.", filteredData.size());
            this.alertsEngine.sendData(filteredData);
        }
        catch (Exception e) {
            this.log.errorf("Failed to send [%d] datums:", (Object)filteredData.size(), (Object)e.getMessage());
        }
    }

    private void processEvents(IncomingEvents incomingEvents) {
        this.log.debugf("Processing [%d] events to AlertsEngine.", incomingEvents.incomingEvents.size());
        TreeSet<Event> filteredEvents = new TreeSet<Event>(this.filterIncomingEvents(incomingEvents));
        this.enforceMinReportingIntervalEvents(filteredEvents);
        try {
            this.alertsEngine.sendEvents(filteredEvents);
        }
        catch (Exception e) {
            this.log.errorf("Failed sending [%d] events: %s", (Object)filteredEvents.size(), (Object)e.getMessage());
        }
    }

    private Collection<Data> filterIncomingData(IncomingData incomingData) {
        Collection data = incomingData.getIncomingData();
        data = incomingData.isRaw() ? this.dataIdCache.filterData(data) : data;
        return data;
    }

    private Collection<Event> filterIncomingEvents(IncomingEvents incomingEvents) {
        Collection events = incomingEvents.getIncomingEvents();
        events = incomingEvents.isRaw() ? this.dataIdCache.filterEvents(events) : events;
        return events;
    }

    private void enforceMinReportingInterval(TreeSet<Data> orderedData) {
        int beforeSize = orderedData.size();
        Data prev = null;
        Iterator<Data> i = orderedData.iterator();
        while (i.hasNext()) {
            Data d = i.next();
            if (!d.same(prev)) {
                prev = d;
                continue;
            }
            if (d.getTimestamp() - prev.getTimestamp() >= (long)this.minReportingIntervalData) continue;
            this.log.tracef("MinReportingInterval violation, prev: %s, removed: %s", (Object)prev, (Object)d);
            i.remove();
        }
        if (this.log.isDebugEnabled() && beforeSize != orderedData.size()) {
            this.log.debugf("MinReportingInterval Data violations: [%d]", beforeSize - orderedData.size());
        }
    }

    private void enforceMinReportingIntervalEvents(TreeSet<Event> orderedEvents) {
        int beforeSize = orderedEvents.size();
        Event prev = null;
        Iterator<Event> i = orderedEvents.iterator();
        while (i.hasNext()) {
            Event e = i.next();
            if (!e.same(prev)) {
                prev = e;
                continue;
            }
            if (e.getCtime() - prev.getCtime() >= (long)this.minReportingIntervalEvents) continue;
            this.log.tracef("MinReportingInterval violation, prev: %s, removed: %s", (Object)prev, (Object)e);
            i.remove();
        }
        if (this.log.isDebugEnabled() && beforeSize != orderedEvents.size()) {
            this.log.debugf("MinReportingInterval Events violations: [%d]", beforeSize - orderedEvents.size());
        }
    }

    private void checkDataDrivenGroupTriggers(Collection<Data> data) {
        if (!this.dataDrivenGroupCacheManager.isCacheActive()) {
            return;
        }
        for (Data d : data) {
            if (this.isEmpty(d.getSource())) continue;
            String tenantId = d.getTenantId();
            String dataId = d.getId();
            String dataSource = d.getSource();
            Set<String> groupTriggerIds = this.dataDrivenGroupCacheManager.needsSourceMember(tenantId, dataId, dataSource);
            for (String groupTriggerId : groupTriggerIds) {
                try {
                    this.definitionsService.addDataDrivenMemberTrigger(tenantId, groupTriggerId, dataSource);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to add Data-Driven Member Trigger for [%s:%s]: %s:", (Object)groupTriggerId, (Object)d, (Object)e.getMessage());
                }
            }
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.isEmpty();
    }

    public static class IncomingEvents {
        private Collection<Event> incomingEvents;
        private boolean raw;

        public IncomingEvents(Collection<Event> incomingEvents, boolean raw) {
            this.incomingEvents = incomingEvents;
            this.raw = raw;
        }

        public Collection<Event> getIncomingEvents() {
            return this.incomingEvents;
        }

        public boolean isRaw() {
            return this.raw;
        }
    }

    public static class IncomingData {
        private Collection<Data> incomingData;
        private boolean raw;

        public IncomingData(Collection<Data> incomingData, boolean raw) {
            this.incomingData = incomingData;
            this.raw = raw;
        }

        public Collection<Data> getIncomingData() {
            return this.incomingData;
        }

        public boolean isRaw() {
            return this.raw;
        }
    }
}

