/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.drools.core.event.DebugAgendaEventListener;
import org.drools.core.event.DebugRuleRuntimeEventListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.service.RulesEngine;
import org.jboss.logging.Logger;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DroolsRulesEngineImpl
implements RulesEngine {
    private final Logger log = Logger.getLogger(DroolsRulesEngineImpl.class);
    private static final String SESSION_NAME = "hawkular-alerts-engine-session";
    private static final long PERF_BATCHING_THRESHOLD = 3000L;
    private static final long PERF_FIRING_THRESHOLD = 5000L;
    private int minReportingIntervalData;
    private int minReportingIntervalEvents;
    private KieServices ks;
    private KieContainer kc;
    private KieSession kSession;
    TreeSet<Data> pendingData = new TreeSet();
    TreeSet<Event> pendingEvents = new TreeSet();

    public DroolsRulesEngineImpl() {
        this.log.debug((Object)"Creating instance.");
        this.ks = KieServices.Factory.get();
        this.kc = this.ks.getKieClasspathContainer();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
        if (this.log.isEnabled(Logger.Level.TRACE)) {
            this.kSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
            this.kSession.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        }
        this.minReportingIntervalData = new Integer(AlertProperties.getProperty("hawkular-alerts.min-reporting-interval-data", "HAWKULAR_MIN_REPORTING_INTERVAL_DATA", "1000"));
        this.minReportingIntervalEvents = new Integer(AlertProperties.getProperty("hawkular-alerts.min-reporting-interval-events", "HAWKULAR_MIN_REPORTING_INTERVAL_EVENTS", "0"));
    }

    @Override
    public void addFact(Object fact) {
        if (fact instanceof Data || fact instanceof Event) {
            throw new IllegalArgumentException(fact.toString());
        }
        this.kSession.insert(fact);
        if (this.log.isDebugEnabled()) {
            this.log.debugf("addFact( %s )", (Object)fact.toString());
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debugf("Fact:  %s", (Object)sessionObject.toString());
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void addFacts(Collection facts) {
        for (Object fact : facts) {
            if (!(fact instanceof Data) && !(fact instanceof Event)) continue;
            throw new IllegalArgumentException(fact.toString());
        }
        for (Object fact : facts) {
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Insert %s", fact);
            }
            this.kSession.insert(fact);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debugf("addFacts( %s )", (Object)facts.toString());
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debugf("Fact:  %s", (Object)sessionObject.toString());
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void addData(TreeSet<Data> data) {
        this.pendingData.addAll(data);
    }

    @Override
    public void addEvents(TreeSet<Event> events) {
        this.pendingEvents.addAll(events);
    }

    @Override
    public void addGlobal(String name, Object global) {
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Add Global %s = %s ", (Object)name, global);
        }
        this.kSession.setGlobal(name, global);
    }

    @Override
    public void clear() {
        for (FactHandle factHandle : this.kSession.getFactHandles()) {
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Delete %s", (Object)factHandle);
            }
            this.kSession.delete(factHandle);
        }
    }

    @Override
    public void fire() {
        int initialPendingData = this.pendingData.size();
        int initialPendingEvents = this.pendingEvents.size();
        int fireCycle = 0;
        long startFiring = System.currentTimeMillis();
        while (!this.pendingData.isEmpty() || !this.pendingEvents.isEmpty()) {
            this.log.debugf("Firing rules... PendingData [%s] PendingEvents [%s]", initialPendingData, initialPendingEvents);
            this.batchData();
            this.batchEvents();
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Firing cycle [%s] - with these facts: ", fireCycle);
                for (FactHandle fact : this.kSession.getFactHandles()) {
                    Object o = this.kSession.getObject(fact);
                    this.log.tracef("Fact: %s", o);
                }
            }
            this.kSession.fireAllRules();
            ++fireCycle;
        }
        long firingTime = System.currentTimeMillis() - startFiring;
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Firing took [%s] ms", firingTime);
        }
        if (firingTime > 5000L) {
            this.log.warnf("Firing rules... PendingData [%s] PendingEvents [%s] took [%s] ms exceeding [%s] ms", new Object[]{initialPendingData, initialPendingEvents, firingTime, 5000L});
        }
    }

    private void batchData() {
        long startBatching = System.currentTimeMillis();
        TreeSet<Data> batchData = this.pendingData;
        this.pendingData = new TreeSet();
        Data previousData = null;
        for (Data d : batchData) {
            if (!d.same(previousData)) {
                previousData = d;
                this.kSession.insert((Object)d);
            } else if (d.getTimestamp() - previousData.getTimestamp() < (long)this.minReportingIntervalData) {
                this.log.tracef("MinReportingInterval violation, prev: %s, removed: %s", (Object)previousData, (Object)d);
            } else {
                this.pendingData.add(d);
                this.log.tracef("Deferring data, keep: %s, defer: %s", (Object)previousData, (Object)d);
            }
            if (this.pendingData.isEmpty()) continue;
            this.log.debugf("Deferring [%d] Datum(s) to next firing !!", this.pendingData.size());
        }
        long batchingTime = System.currentTimeMillis() - startBatching;
        this.log.debugf("Batching Data [%s] took [%s]", (long)batchData.size(), batchingTime);
        if (batchingTime > 3000L) {
            this.log.warnf("Batching Data [%s] took [%s] ms exceeding [%s] ms", (Object)batchData.size(), (Object)batchingTime, (Object)3000L);
        }
    }

    private void batchEvents() {
        long startBatching = System.currentTimeMillis();
        TreeSet<Event> batchEvents = this.pendingEvents;
        this.pendingEvents = new TreeSet();
        Event previousEvent = null;
        for (Event e : batchEvents) {
            if (!e.same(previousEvent)) {
                previousEvent = e;
                this.kSession.insert((Object)e);
                continue;
            }
            if (e.getCtime() - previousEvent.getCtime() < (long)this.minReportingIntervalEvents) {
                this.log.tracef("MinReportingInterval violation, prev: %s, removed: %s", (Object)previousEvent, (Object)e);
                continue;
            }
            this.pendingEvents.add(e);
            this.log.tracef("Deferring event, keep: %s, defer: %s", (Object)previousEvent, (Object)e);
        }
        if (!this.pendingEvents.isEmpty()) {
            this.log.debugf("Deferring [%d] Event(s) to next firing !!", this.pendingEvents.size());
        }
        long batchingTime = System.currentTimeMillis() - startBatching;
        this.log.debugf("Batching Events [%s] took [%s]", (long)batchEvents.size(), batchingTime);
        if (batchingTime > 3000L) {
            this.log.warnf("Batching Events [%s] took [%s] ms exceeding [%s] ms", (Object)batchEvents.size(), (Object)batchingTime, (Object)3000L);
        }
    }

    @Override
    public void fireNoData() {
        this.kSession.fireAllRules();
    }

    @Override
    public Object getFact(Object o) {
        Object result = null;
        FactHandle factHandle = this.kSession.getFactHandle(o);
        if (null != factHandle) {
            result = this.kSession.getObject(factHandle);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debugf("getFact( %s )", (Object)o.toString());
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle fact : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(fact);
                this.log.debugf("Fact:  %s", (Object)sessionObject.toString());
            }
            this.log.debug((Object)"==> End Dump");
        }
        return result;
    }

    @Override
    public void removeFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Delete %s", (Object)factHandle);
            }
            this.kSession.delete(factHandle);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debugf("removeFact( %s )", (Object)fact.toString());
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debugf("Fact:  %s", (Object)sessionObject.toString());
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void updateFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Update %s", (Object)factHandle);
            }
            this.kSession.update(factHandle, fact);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debugf("updateFact( %s )", (Object)fact.toString());
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debugf("Fact:  %s", (Object)sessionObject.toString());
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void removeFacts(Collection facts) {
        for (Object fact : facts) {
            this.removeFact(fact);
        }
    }

    @Override
    public void removeFacts(final Predicate<Object> factFilter) {
        Collection handles = this.kSession.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return factFilter.test(object);
            }
        });
        if (null == handles) {
            return;
        }
        for (FactHandle h : handles) {
            this.removeFact(h);
        }
    }

    @Override
    public void removeGlobal(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Remove Global %s", (Object)name);
        }
        this.kSession.setGlobal(name, null);
    }

    @Override
    public void reset() {
        this.log.debug((Object)"Reset session");
        this.kSession.dispose();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
    }
}

