/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.List;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.export.Definitions;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.jboss.logging.Logger;

public class AlertsImportManager {
    private static final Logger log = Logger.getLogger(AlertsImportManager.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private Definitions definitions;

    public AlertsImportManager(File fAlerts) throws Exception {
        if (fAlerts == null) {
            throw new IllegalArgumentException("fAlerts must be not null");
        }
        if (!fAlerts.exists() || !fAlerts.isFile()) {
            throw new IllegalArgumentException(fAlerts.getName() + " file must exist");
        }
        this.definitions = (Definitions)this.objectMapper.readValue(fAlerts, Definitions.class);
        if (log.isDebugEnabled()) {
            if (this.definitions != null) {
                log.debug((Object)("File: " + fAlerts.toString() + " imported in " + this.definitions.toString()));
            } else {
                log.debug((Object)("File: " + fAlerts.toString() + " imported is null"));
            }
        }
    }

    public List<FullTrigger> getFullTriggers() {
        return this.definitions != null ? this.definitions.getTriggers() : null;
    }

    public List<ActionDefinition> getActionDefinitions() {
        return this.definitions != null ? this.definitions.getActions() : null;
    }
}

