/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine;

import com.datastax.driver.core.Session;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertsContext;
import org.hawkular.alerts.engine.impl.AlertsEngineImpl;
import org.hawkular.alerts.engine.impl.CassActionsServiceImpl;
import org.hawkular.alerts.engine.impl.CassAlertsServiceImpl;
import org.hawkular.alerts.engine.impl.CassDefinitionsServiceImpl;
import org.hawkular.alerts.engine.impl.DroolsRulesEngineImpl;
import org.hawkular.alerts.engine.impl.PropertiesServiceImpl;
import org.jboss.logging.Logger;

public class StandaloneAlerts {
    private static final int INIT_TIME_COUNT = 10;
    private static final int INIT_TIME_SLEEP = 500;
    private final Logger log = Logger.getLogger(StandaloneAlerts.class);
    private static StandaloneAlerts instance = null;
    private PropertiesServiceImpl propertiesService = null;
    private AlertsContext alertsContext = null;
    private CassActionsServiceImpl actions = null;
    private CassAlertsServiceImpl alerts = null;
    private CassDefinitionsServiceImpl definitions = null;
    private AlertsEngineImpl engine = null;
    private DroolsRulesEngineImpl rules = null;
    private StandaloneExecutorService executor = new StandaloneExecutorService();

    private StandaloneAlerts(Session session) {
        this.actions = new CassActionsServiceImpl();
        this.rules = new DroolsRulesEngineImpl();
        this.engine = new AlertsEngineImpl();
        this.definitions = new CassDefinitionsServiceImpl();
        this.propertiesService = new PropertiesServiceImpl();
        this.alerts = new CassAlertsServiceImpl();
        this.alerts.setSession(session);
        this.alerts.setExecutor(this.executor);
        this.alerts.setProperties(this.propertiesService);
        this.alerts.init();
        this.alertsContext = new AlertsContext();
        this.definitions.setSession(session);
        this.definitions.setAlertsEngine(this.engine);
        this.definitions.setAlertsContext(this.alertsContext);
        this.definitions.setProperties(this.propertiesService);
        this.definitions.init();
        this.actions.setSession(session);
        this.actions.setAlertsContext(this.alertsContext);
        this.actions.setDefinitions(this.definitions);
        this.actions.setExecutor(this.executor);
        this.engine.setDefinitions(this.definitions);
        this.engine.setActions(this.actions);
        this.engine.setRules(this.rules);
        this.log.debug((Object)"Waiting for initialization...");
        try {
            for (int i = 0; i < 10; ++i) {
                this.log.debug((Object)".");
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized DefinitionsService getDefinitionsService(Session session) {
        if (instance == null) {
            instance = new StandaloneAlerts(session);
        }
        return StandaloneAlerts.instance.definitions;
    }

    public static synchronized AlertsService getAlertsService(Session session) {
        if (instance == null) {
            instance = new StandaloneAlerts(session);
        }
        return StandaloneAlerts.instance.alerts;
    }

    public static synchronized ActionsService getActionsService(Session session) {
        if (instance == null) {
            instance = new StandaloneAlerts(session);
        }
        return StandaloneAlerts.instance.actions;
    }

    public static class StandaloneExecutorService
    implements ManagedExecutorService {
        private ExecutorService executor = Executors.newSingleThreadExecutor();

        public void shutdown() {
            this.executor.shutdown();
        }

        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.executor.invokeAll(tasks);
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.invokeAll(tasks, timeout, unit);
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(tasks);
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executor.invokeAny(tasks, timeout, unit);
        }

        public void execute(Runnable command) {
            this.executor.execute(command);
        }
    }
}

