/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.HashSet;
import java.util.Set;

public class AlertsEngineCache {
    private Set<DataEntry> activeDataEntries = new HashSet<DataEntry>();
    private Set<DataId> activeDataIds = new HashSet<DataId>();

    public boolean isDataIdActive(String tenantId, String dataId) {
        return tenantId != null && dataId != null && this.activeDataIds.contains(new DataId(tenantId, dataId));
    }

    public void add(DataEntry dataEntry) {
        this.activeDataEntries.add(dataEntry);
        DataId newDataId = new DataId(dataEntry.getTenantId(), dataEntry.getDataId());
        if (!this.activeDataIds.contains(newDataId)) {
            this.activeDataIds.add(newDataId);
        }
    }

    public void remove(String tenantId, String triggerId) {
        if (tenantId == null) {
            throw new IllegalArgumentException("tenantId must be not null");
        }
        if (triggerId == null) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        HashSet dataEntriesToRemove = new HashSet();
        this.activeDataEntries.stream().forEach(e -> {
            if (e.getTenantId().equals(tenantId) && e.getTriggerId().equals(triggerId)) {
                dataEntriesToRemove.add(e);
            }
        });
        this.activeDataEntries.removeAll(dataEntriesToRemove);
        HashSet dataIdToCheck = new HashSet();
        dataEntriesToRemove.stream().forEach(e -> dataIdToCheck.add(new DataId(e.getTenantId(), e.getDataId())));
        HashSet dataIdToRemove = new HashSet();
        dataIdToCheck.stream().forEach(dataId -> {
            boolean found = false;
            for (DataEntry entry : this.activeDataEntries) {
                DataId currentDataId = new DataId(entry.getTenantId(), entry.getDataId());
                if (!currentDataId.equals(dataId)) continue;
                found = true;
                break;
            }
            if (!found) {
                dataIdToRemove.add(dataId);
            }
        });
        this.activeDataIds.removeAll(dataIdToRemove);
    }

    public void clear() {
        this.activeDataEntries.clear();
        this.activeDataIds.clear();
    }

    public static class DataEntry {
        String tenantId;
        String triggerId;
        String dataId;

        public DataEntry(String tenantId, String triggerId, String dataId) {
            if (tenantId == null) {
                throw new NullPointerException("triggerId must be not null");
            }
            if (triggerId == null) {
                throw new NullPointerException("triggerId must be not null");
            }
            if (dataId == null) {
                throw new NullPointerException("dataId must be not null");
            }
            this.tenantId = tenantId;
            this.triggerId = triggerId;
            this.dataId = dataId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataEntry dataEntry = (DataEntry)o;
            if (this.tenantId != null ? !this.tenantId.equals(dataEntry.tenantId) : dataEntry.tenantId != null) {
                return false;
            }
            if (this.triggerId != null ? !this.triggerId.equals(dataEntry.triggerId) : dataEntry.triggerId != null) {
                return false;
            }
            return !(this.dataId == null ? dataEntry.dataId != null : !this.dataId.equals(dataEntry.dataId));
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DataEntry[tenantId='" + this.tenantId + '\'' + ", triggerId='" + this.triggerId + '\'' + ", dataId='" + this.dataId + '\'' + ']';
        }
    }

    public static class DataId {
        String tenantId;
        String dataId;

        public DataId(String tenantId, String dataId) {
            this.tenantId = tenantId;
            this.dataId = dataId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataId dataId1 = (DataId)o;
            if (this.tenantId != null ? !this.tenantId.equals(dataId1.tenantId) : dataId1.tenantId != null) {
                return false;
            }
            return this.dataId != null ? this.dataId.equals(dataId1.dataId) : dataId1.dataId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DataId{tenantId='" + this.tenantId + '\'' + ", dataId='" + this.dataId + '\'' + '}';
        }
    }
}

