/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.hawkular.alerts.api.services.DataExtension;
import org.hawkular.alerts.api.services.EventExtension;
import org.hawkular.alerts.api.services.ExtensionsService;
import org.jboss.logging.Logger;

@Singleton
@Startup
@Local(value={ExtensionsService.class})
public class ExtensionsServiceImpl
implements ExtensionsService {
    private final Logger log = Logger.getLogger(ExtensionsServiceImpl.class);
    Set<DataExtension> dataExtensions;
    Set<EventExtension> eventsExtensions;

    @PostConstruct
    public void init() {
        this.dataExtensions = new HashSet<DataExtension>();
        this.eventsExtensions = new HashSet<EventExtension>();
    }

    public void addExtension(DataExtension extension) {
        this.log.infof("Adding DataExtension %s", (Object)extension);
        this.dataExtensions.add(extension);
    }

    public void addExtension(EventExtension extension) {
        this.log.infof("Adding EventExtension %s", (Object)extension);
        this.eventsExtensions.add(extension);
    }

    @Lock(value=LockType.READ)
    public Set<DataExtension> getDataExtensions() {
        return this.dataExtensions;
    }

    @Lock(value=LockType.READ)
    public Set<EventExtension> getEventExtensions() {
        return this.eventsExtensions;
    }
}

