/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.extensions.CepEngine;
import org.hawkular.alerts.extensions.Expression;
import org.jboss.logging.Logger;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.utils.KieHelper;

@Singleton
@Startup
public class CepEngineImpl
implements CepEngine {
    private final Logger log = Logger.getLogger(CepEngineImpl.class);
    Expression expression;
    List<Event> results;
    KieSession kieSession;
    @EJB
    private AlertsService alertsService;
    @Resource
    private ManagedExecutorService executor;

    @Override
    @Lock(value=LockType.READ)
    public void processEvents(TreeSet<Event> events) {
        if (this.kieSession != null) {
            events.stream().forEach(e -> this.kieSession.insert(e));
        }
    }

    @Override
    @Lock(value=LockType.READ)
    public void sendResult(Event event) {
        this.log.debugf("Resulted event %s", (Object)event);
        this.executor.submit(() -> {
            try {
                this.alertsService.sendEvents(Arrays.asList(event));
            }
            catch (Exception e) {
                this.log.error((Object)"Error sending result events.", (Throwable)e);
            }
        });
    }

    @Override
    public void updateConditions(String expiration, Collection<FullTrigger> activeTriggers) {
        this.expression = new Expression(expiration, activeTriggers);
        this.log.debugf("Rules: \n %s", (Object)this.expression);
        this.stop();
        KieBaseConfiguration kieBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KieBase kieBase = new KieHelper().addContent(this.expression.getDrl(), ResourceType.DRL).build(kieBaseConfiguration);
        KieSessionConfiguration kieSessionConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        kieSessionConf.setOption((KieSessionOption)ClockTypeOption.get((String)"realtime"));
        this.kieSession = kieBase.newKieSession(kieSessionConf, null);
        this.results = new ArrayList<Event>();
        this.kieSession.setGlobal("results", (Object)this);
        this.kieSession.setGlobal("log", (Object)this.log);
        if (this.log.isDebugEnabled()) {
            this.kieSession.addEventListener((AgendaEventListener)new CepAgendaEventListener());
            this.kieSession.addEventListener((RuleRuntimeEventListener)new CepRuleRuntimeEventListener());
        }
        this.log.infof("Clock time [%s] ", (Object)this.kieSession.getSessionClock().getCurrentTime());
        this.kieSession.getKieBase().getKiePackages().stream().forEach(p -> this.log.debugf("Rules: %s", (Object)p.getRules()));
        this.executor.submit(() -> {
            this.log.info((Object)"Starting fireUntilHalt()");
            this.kieSession.fireUntilHalt();
            this.log.info((Object)"Stopping fireUntilHalt()");
        });
    }

    @Override
    public void stop() {
        if (this.kieSession != null) {
            this.kieSession.halt();
            this.kieSession.dispose();
            this.kieSession.destroy();
            this.kieSession = null;
            this.log.info((Object)"Sent halt() signal to CEP session");
        }
    }

    public static class CepRuleRuntimeEventListener
    implements RuleRuntimeEventListener {
        private final Logger log = Logger.getLogger(CepRuleRuntimeEventListener.class);

        public void objectInserted(ObjectInsertedEvent event) {
            this.log.debug((Object)event);
        }

        public void objectUpdated(ObjectUpdatedEvent event) {
            this.log.debug((Object)event);
        }

        public void objectDeleted(ObjectDeletedEvent event) {
            this.log.debug((Object)event);
        }
    }

    public static class CepAgendaEventListener
    implements AgendaEventListener {
        private final Logger log = Logger.getLogger(CepAgendaEventListener.class);

        public void matchCreated(MatchCreatedEvent event) {
            this.log.debug((Object)event);
        }

        public void matchCancelled(MatchCancelledEvent event) {
            this.log.debug((Object)event);
        }

        public void beforeMatchFired(BeforeMatchFiredEvent event) {
            this.log.debug((Object)event);
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
            this.log.debug((Object)event);
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            this.log.debug((Object)event);
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            this.log.debug((Object)event);
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            this.log.debug((Object)event);
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            this.log.debug((Object)event);
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            this.log.debug((Object)event);
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            this.log.debug((Object)event);
        }
    }
}

