/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedExecutorService;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.DistributedEvent;
import org.hawkular.alerts.api.services.EventExtension;
import org.hawkular.alerts.api.services.ExtensionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.extensions.CepEngine;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class EventsAggregationExtension
implements EventExtension {
    private final Logger log = Logger.getLogger(EventsAggregationExtension.class);
    private static final String ENGINE_EXTENSIONS = "hawkular-alerts.engine-extensions";
    private static final String ENGINE_EXTENSIONS_ENV = "ENGINE_EXTENSIONS";
    private static final String ENGINE_EXTENSIONS_DEFAULT = "true";
    boolean engineExtensions;
    private static final String TAG_NAME = "HawkularExtension";
    private static final String TAG_VALUE = "EventsAggregation";
    private static final String EVENTS_EXPIRATION = "hawkular-alerts.extension-events-expiration";
    private static final String EVENTS_EXPIRATION_ENV = "EXTENSION_EVENTS_EXPIRATION";
    private static final String EVENTS_EXTENSIONS_DEFAULT = "30m";
    private String defaultExpiration;
    private static final String CONTEXT_PROCESSED = "processed";
    private Map<TriggerKey, FullTrigger> activeTriggers = new HashMap<TriggerKey, FullTrigger>();
    @EJB
    private PropertiesService properties;
    @EJB
    private DefinitionsService definitions;
    @EJB
    private ExtensionsService extensions;
    @EJB
    private CepEngine cep;
    @Resource
    private ManagedExecutorService executor;

    @PostConstruct
    public void init() {
        this.engineExtensions = Boolean.parseBoolean(this.properties.getProperty(ENGINE_EXTENSIONS, ENGINE_EXTENSIONS_ENV, ENGINE_EXTENSIONS_DEFAULT));
        this.defaultExpiration = this.properties.getProperty(EVENTS_EXPIRATION, EVENTS_EXPIRATION_ENV, EVENTS_EXTENSIONS_DEFAULT);
        if (this.engineExtensions) {
            this.log.info((Object)"Registering Distributed Trigger listener");
            this.definitions.registerDistributedListener(events -> this.refresh(events));
            this.extensions.addExtension((EventExtension)this);
        }
    }

    private Set<DistributedEvent> optimizeEvents(Set<DistributedEvent> distEvents) {
        HashMap map = new HashMap();
        distEvents.stream().forEach(event -> map.put(new TriggerKey(event.getTenantId(), event.getTriggerId()), event.getOperation()));
        HashSet<DistributedEvent> optimizedEvents = new HashSet<DistributedEvent>();
        map.entrySet().stream().forEach(entry -> optimizedEvents.add(new DistributedEvent((DistributedEvent.Operation)entry.getValue(), ((TriggerKey)entry.getKey()).getTenantId(), ((TriggerKey)entry.getKey()).getTriggerId())));
        return optimizedEvents;
    }

    private void refresh(Set<DistributedEvent> distEvents) {
        Set<DistributedEvent> optimizedEvents = this.optimizeEvents(distEvents);
        this.executor.submit(() -> {
            try {
                for (DistributedEvent distEvent : optimizedEvents) {
                    switch (distEvent.getOperation()) {
                        case REMOVE: {
                            this.activeTriggers.remove(new TriggerKey(distEvent.getTenantId(), distEvent.getTriggerId()));
                            break;
                        }
                        case ADD: 
                        case UPDATE: {
                            Trigger trigger = this.definitions.getTrigger(distEvent.getTenantId(), distEvent.getTriggerId());
                            if (trigger == null || !trigger.getTags().containsKey(TAG_NAME) || !((String)trigger.getTags().get(TAG_NAME)).equals(TAG_VALUE)) break;
                            this.log.infof("Found [%s]", (Object)trigger.getName());
                            Collection conditions = null;
                            ArrayList<ExternalCondition> activeConditions = new ArrayList<ExternalCondition>();
                            try {
                                if (!trigger.isGroup()) {
                                    conditions = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                                    this.log.infof("Checking [%s] Conditions for enabled trigger [%s]!", (Object)conditions.size(), (Object)trigger.getName());
                                }
                            }
                            catch (Exception e) {
                                this.log.error((Object)("Failed to fetch Conditions when scheduling metrics conditions for " + trigger), (Throwable)e);
                                break;
                            }
                            if (null == conditions) break;
                            for (Condition condition : conditions) {
                                ExternalCondition externalCondition;
                                if (!(condition instanceof ExternalCondition) || !TAG_VALUE.equals((externalCondition = (ExternalCondition)condition).getAlerterId())) continue;
                                activeConditions.add(externalCondition);
                            }
                            TriggerKey triggerKey = new TriggerKey(trigger.getTenantId(), trigger.getId());
                            if (activeConditions.isEmpty()) {
                                this.activeTriggers.remove(triggerKey);
                                break;
                            }
                            FullTrigger activeTrigger = new FullTrigger();
                            activeTrigger.setTrigger(trigger);
                            activeTrigger.setConditions(activeConditions);
                            this.activeTriggers.put(triggerKey, activeTrigger);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to fetch Triggers for external conditions.", (Throwable)e);
            }
            if (this.activeTriggers.isEmpty()) {
                this.cep.stop();
            } else {
                this.cep.updateConditions(this.defaultExpiration, this.activeTriggers.values());
            }
        });
    }

    @Lock(value=LockType.READ)
    public TreeSet<Event> processEvents(TreeSet<Event> events) {
        if (this.isEmpty(events)) {
            return events;
        }
        TreeSet<Event> retained = new TreeSet<Event>();
        TreeSet<Event> filtered = new TreeSet<Event>();
        for (Event event : events) {
            if (event.getTags() != null && TAG_VALUE.equals(event.getTags().get(TAG_NAME)) && event.getContext().get(CONTEXT_PROCESSED) == null) {
                retained.add(event);
                continue;
            }
            if (event.getContext().get(CONTEXT_PROCESSED) != null) {
                event.getContext().remove(CONTEXT_PROCESSED);
            }
            filtered.add(event);
        }
        if (!retained.isEmpty()) {
            this.executor.submit(() -> this.cep.processEvents(retained));
        }
        return filtered;
    }

    private boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    private class TriggerKey {
        private String tenantId;
        private String triggerId;

        public TriggerKey(String tenantId, String triggerId) {
            this.tenantId = tenantId;
            this.triggerId = triggerId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerKey that = (TriggerKey)o;
            if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
                return false;
            }
            return this.triggerId != null ? this.triggerId.equals(that.triggerId) : that.triggerId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            return result;
        }
    }
}

