/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.extensions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class Expression {
    private static final String DRL_HEADER = "  package org.hawkular.alerts.extension \n  import org.hawkular.alerts.api.model.event.Event; \n  import org.hawkular.alerts.api.json.JsonUtil; \n  import org.hawkular.alerts.extensions.CepEngine; \n  import org.kie.api.time.SessionClock; \n  import org.jboss.logging.Logger; \n  import java.util.List; \n  import java.util.UUID; \n\n  global Logger log; \n  global CepEngine results; \n  global SessionClock clock;\n  \n";
    private static final String BLANK = "                ";
    private static final String CONTEXT = "context";
    private static final String DEFAULT_EXPIRATION = "30m";
    private static final String FUNCTION_COUNT = "$count : count( $event )";
    private static final String FUNCTION_EVENTS = "$events : collectList( $event )";
    private static final int GROUP_INDEX = 1;
    private static final Pattern SEARCH_CONTEXT = Pattern.compile("context\\.(\\w+)\\s");
    private static final Pattern SEARCH_TAGS = Pattern.compile("tags\\.(\\w+)\\s");
    private static final String TAGS = "tags";
    private static final String TOKEN_COMMA = ",";
    private static final String TOKEN_CONTEXT = "context.";
    private static final String TOKEN_COUNT = "count ";
    private static final String TOKEN_COUNT_CONTEXT = "count.context.";
    private static final String TOKEN_COUNT_TAGS = "count.tags.";
    private static final int TOKEN_END_PARENTHESIS = 41;
    private static final String TOKEN_EVENT = "event";
    private static final String TOKEN_FILTER = "filter(";
    private static final String TOKEN_GROUP_BY = "groupBy(";
    private static final String TOKEN_HAVING = "having(";
    private static final String TOKEN_LENGTH = "length,";
    private static final String TOKEN_SEPARATOR = ":";
    private static final String TOKEN_TAGS = "tags.";
    private static final String TOKEN_TIME = "time,";
    private static final String TOKEN_WINDOW = "window(";
    private static final String VARIABLE_COUNT = "\\$count ";
    private String expRuleName;
    private String alerterId;
    private String expression;
    private String tenantId;
    private String source;
    private String dataId;
    private Set<String> declareFields = new HashSet<String>();
    private Set<String> ruleNames = new HashSet<String>();
    private String drlGroupByDeclare;
    private String drlGroupByObject;
    private String drlGroupByConstraint;
    private String drlGroupByResult;
    private String drlWindow;
    private Set<String> drlEventConstraints = new HashSet<String>();
    private Set<String> drlFunctions = new HashSet<String>();
    private Set<String> drlFunctionsConstraints = new HashSet<String>();
    private String drl;

    public Expression(Collection<FullTrigger> activeTriggers) {
        this(null, activeTriggers);
    }

    public Expression(String expiration, Collection<FullTrigger> activeTriggers) {
        if (Expression.isEmpty(expiration)) {
            expiration = DEFAULT_EXPIRATION;
        }
        if (Expression.isEmpty(activeTriggers)) {
            throw new IllegalArgumentException("ActiveTriggers must be not empty");
        }
        this.drl = "  package org.hawkular.alerts.extension \n  import org.hawkular.alerts.api.model.event.Event; \n  import org.hawkular.alerts.api.json.JsonUtil; \n  import org.hawkular.alerts.extensions.CepEngine; \n  import org.kie.api.time.SessionClock; \n  import org.jboss.logging.Logger; \n  import java.util.List; \n  import java.util.UUID; \n\n  global Logger log; \n  global CepEngine results; \n  global SessionClock clock;\n  \n\n";
        this.drl = this.drl + "  declare Event \n    @role( event ) \n    @expires( " + expiration + " ) \n    @timestamp( ctime ) \n  end \n\n";
        activeTriggers.stream().forEach(fullTrigger -> fullTrigger.getConditions().forEach(condition -> {
            if (condition instanceof ExternalCondition) {
                this.buildTriggerDrl(fullTrigger.getTrigger(), (ExternalCondition)condition);
                this.drl = this.drl + "\n";
                this.drlEventConstraints.clear();
                this.drlFunctions.clear();
                this.drlFunctionsConstraints.clear();
            }
        }));
    }

    private void buildTriggerDrl(Trigger trigger, ExternalCondition condition) {
        if (trigger == null || condition == null) {
            throw new IllegalArgumentException("Trigger or Condition must be not null");
        }
        this.expRuleName = trigger.getName() + "-" + condition.getConditionId();
        this.alerterId = condition.getAlerterId();
        this.expression = condition.getExpression();
        this.tenantId = trigger.getTenantId();
        this.source = trigger.getSource();
        this.dataId = condition.getDataId();
        this.drlWindow = "";
        if (Expression.isEmpty(this.expression)) {
            throw new IllegalArgumentException("Expression must be not null");
        }
        String[] section = this.expression.split(TOKEN_SEPARATOR);
        if (section.length < 2 || section.length > 5) {
            throw new IllegalArgumentException("Wrong sections for expression [" + this.expression + "]");
        }
        if (!section[0].equals(TOKEN_EVENT)) {
            throw new IllegalArgumentException("Expression [" + this.expression + "] must start with 'event'");
        }
        if (!section[1].startsWith(TOKEN_GROUP_BY)) {
            throw new IllegalArgumentException("Expression [" + this.expression + "] must contain a 'groupBy()' section");
        }
        this.parseGroupBy(section[1]);
        this.drlFunctions.add(FUNCTION_EVENTS);
        for (int i = 2; i < section.length; ++i) {
            if (section[i].startsWith(TOKEN_WINDOW)) {
                this.parseWindow(section[i]);
                continue;
            }
            if (section[i].startsWith(TOKEN_FILTER)) {
                this.parseFilter(section[i]);
                continue;
            }
            if (section[i].startsWith(TOKEN_HAVING)) {
                this.parseHaving(section[i]);
                continue;
            }
            throw new IllegalArgumentException("Expression [" + this.expression + "] contains an invalid '" + section[i] + "' section");
        }
        if (!this.ruleNames.contains(this.expRuleName)) {
            this.ruleNames.add(this.expRuleName);
            this.addTriggerDrl(this.expRuleName);
        }
    }

    private void parseGroupBy(String section) {
        int endSection = section.lastIndexOf(41);
        if (endSection == -1) {
            throw new IllegalArgumentException("Expression [" + section + " must contain a valid 'groupBy()'");
        }
        String innerSection = section.substring(TOKEN_GROUP_BY.length(), endSection).trim();
        boolean tags = false;
        boolean context = false;
        if (innerSection.startsWith(TOKEN_TAGS)) {
            tags = true;
        }
        if (innerSection.startsWith(TOKEN_CONTEXT)) {
            context = true;
        }
        String field = tags ? innerSection.substring(TOKEN_TAGS.length()) : (context ? innerSection.substring(TOKEN_CONTEXT.length()) : innerSection);
        String type = Expression.makeType(field);
        this.drlGroupByObject = type + " ( $tenantId : tenantId == \"" + this.tenantId + "\",$source : source == \"" + this.source + "\", $dataId : dataId == \"" + this.dataId + "\", $" + field + " : " + field + " )";
        this.drlGroupByConstraint = tags ? " tags[ \"" + field + "\" ] == $" + field + " " : (context ? " context[ \"" + field + "\" ] == $" + field + " " : " " + field + " == $" + field + " ");
        this.drlGroupByResult = "    result.addContext(\"" + field + "\", $" + field + "); \n";
        this.drlEventConstraints.add(this.drlGroupByConstraint);
        if (this.declareFields.contains(field)) {
            this.drlGroupByDeclare = "";
        } else {
            this.declareFields.add(field);
            this.drlGroupByDeclare = "  declare " + type + " \n    tenantId : String \n    source : String \n    dataId : String \n    " + field + " : String \n  end \n\n";
        }
        String extractRuleName = "Extract " + field + " from " + this.tenantId + "-" + this.source + "-" + this.dataId;
        if (!this.ruleNames.contains(extractRuleName)) {
            this.ruleNames.add(extractRuleName);
            this.drlGroupByDeclare = this.drlGroupByDeclare + "  rule \"" + extractRuleName + "\" \n  when \n    Event ( $tenantId : tenantId == \"" + this.tenantId + "\", \n            $dataSource : dataSource == \"" + this.source + "\", \n            $dataId : dataId == \"" + this.dataId + "\", \n            $" + field + " : ";
            this.drlGroupByDeclare = tags ? this.drlGroupByDeclare + "tags[ \"" + field + "\" ] != null ) \n" : (context ? this.drlGroupByDeclare + "context[ \"" + field + "\" ] != null ) \n" : this.drlGroupByDeclare + field + " != null ) \n");
            this.drlGroupByDeclare = this.drlGroupByDeclare + "   not " + type + " ( tenantId == $tenantId, source == $dataSource, dataId == $dataId, " + field + " == $" + field + " ) \n  then \n    insert ( new " + type + " ( $tenantId, $dataSource, $dataId, $" + field + " ) ); \n  end \n\n";
        }
    }

    private void parseWindow(String section) {
        int endSection = section.lastIndexOf(41);
        if (endSection == -1) {
            throw new IllegalArgumentException("Expression [" + section + " must contain a valid 'window()'");
        }
        String innerSection = section.substring(TOKEN_WINDOW.length(), endSection).trim();
        if (innerSection.startsWith(TOKEN_TIME)) {
            this.drlWindow = this.drlWindow + " over window:time(" + innerSection.substring(TOKEN_TIME.length()) + ")";
        } else if (innerSection.startsWith(TOKEN_LENGTH)) {
            this.drlWindow = this.drlWindow + " over window:length(" + innerSection.substring(TOKEN_LENGTH.length()) + ")";
        } else {
            new IllegalArgumentException("Expresion [" + section + " must contain a valid 'time' or 'length' token");
        }
    }

    private void parseFilter(String section) {
        int endSection = section.lastIndexOf(41);
        if (endSection == -1) {
            throw new IllegalArgumentException("Expression [" + section + " must contain a valid 'filter()'");
        }
        String innerSection = section.substring(TOKEN_FILTER.length(), endSection).trim();
        String[] filterConstraints = innerSection.split(TOKEN_COMMA);
        for (int i = 0; i < filterConstraints.length; ++i) {
            if (filterConstraints[i].contains(TOKEN_CONTEXT)) {
                filterConstraints[i] = Expression.replaceMap(filterConstraints[i], SEARCH_CONTEXT, CONTEXT);
            }
            if (filterConstraints[i].contains(TOKEN_TAGS)) {
                filterConstraints[i] = Expression.replaceMap(filterConstraints[i], SEARCH_TAGS, TAGS);
            }
            this.drlEventConstraints.add(filterConstraints[i]);
        }
    }

    private void parseHaving(String section) {
        int endSection = section.lastIndexOf(41);
        if (endSection == -1) {
            throw new IllegalArgumentException("Expression [" + section + " must contain a valid 'having()'");
        }
        String innerSection = section.substring(TOKEN_HAVING.length(), endSection).trim();
        String[] havingConstraints = innerSection.split(TOKEN_COMMA);
        for (int i = 0; i < havingConstraints.length; ++i) {
            if (havingConstraints[i].contains(TOKEN_COUNT)) {
                havingConstraints[i] = havingConstraints[i].replaceAll(TOKEN_COUNT, VARIABLE_COUNT);
                this.drlFunctions.add(FUNCTION_COUNT);
            }
            if (havingConstraints[i].contains(TOKEN_COUNT_CONTEXT)) {
                havingConstraints[i] = this.processCountContext(havingConstraints[i]);
            }
            if (havingConstraints[i].contains(TOKEN_COUNT_TAGS)) {
                havingConstraints[i] = this.processCountTags(havingConstraints[i]);
            }
            this.drlFunctionsConstraints.add(havingConstraints[i].trim());
        }
    }

    private void addTriggerDrl(String name) {
        this.drl = this.drl + this.drlGroupByDeclare + "  rule \"" + name + "\" \n  when \n    " + this.drlGroupByObject + " \n    accumulate( $event : Event( tenantId == $tenantId, \n                                dataSource == $source, \n                                dataId == $dataId, \n";
        Iterator<String> it = this.drlEventConstraints.iterator();
        while (it.hasNext()) {
            String eventConstraint = it.next();
            this.drl = this.drl + "                                " + eventConstraint;
            if (!it.hasNext()) continue;
            this.drl = this.drl + ", \n";
        }
        this.drl = this.drl + ") " + this.drlWindow + "; \n";
        it = this.drlFunctions.iterator();
        while (it.hasNext()) {
            this.drl = this.drl + BLANK + it.next();
            if (!it.hasNext()) continue;
            this.drl = this.drl + ", \n";
        }
        this.drl = this.drl + "; \n";
        it = this.drlFunctionsConstraints.iterator();
        while (it.hasNext()) {
            this.drl = this.drl + BLANK + it.next();
            if (!it.hasNext()) continue;
            this.drl = this.drl + ", \n";
        }
        this.drl = this.drl + ") \n";
        this.drl = this.drl + "  then \n    Event result = new Event(\"" + this.tenantId + "\", \n                             UUID.randomUUID().toString(), \n                             \"" + this.dataId + "\", \n                             \"" + this.alerterId + "\", \n                             \"" + this.expression.replaceAll("\"", "'") + "\"); \n    result.addContext(\"events\", JsonUtil.toJson($events)); \n    result.addContext(\"processed\", \"true\"); \n" + this.drlGroupByResult + "    results.sendResult( result ); \n  end \n";
    }

    public String getDrl() {
        return this.drl;
    }

    private String processCountContext(String str) {
        int start = str.indexOf(TOKEN_COUNT_CONTEXT);
        int end = str.indexOf(32, start);
        String countContext = str.substring(start, end);
        String field = countContext.substring(TOKEN_COUNT_CONTEXT.length());
        this.drlFunctions.add("$" + field + "ContextSet : collectSet($event.getContext().get(\"" + field + "\") )");
        return str.replaceAll(countContext, "\\$" + field + "ContextSet.size");
    }

    private String processCountTags(String str) {
        int start = str.indexOf(TOKEN_COUNT_TAGS);
        int end = str.indexOf(32, start);
        String countTags = str.substring(start, end);
        String field = countTags.substring(TOKEN_COUNT_TAGS.length());
        this.drlFunctions.add("$" + field + "TagsSet : collectSet($event.getTags().get(\"" + field + "\") )");
        return str.replaceAll(countTags, "\\$" + field + "TagsSet.size");
    }

    private static String makeType(String field) {
        return field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    private static String replaceMap(String str, Pattern pattern, String map) {
        String newStr = str;
        Matcher matcher = pattern.matcher(str);
        int index = 0;
        while (matcher.find(index)) {
            int end = matcher.end();
            String original = matcher.group();
            String field = matcher.group(1);
            index = end;
            newStr = newStr.replaceAll(original, map + "[\"" + field + "\"]");
        }
        return newStr;
    }

    private static boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private static boolean isEmpty(Collection c) {
        return null == c || c.isEmpty();
    }

    public String toString() {
        return this.getDrl();
    }
}

