/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ResponseUtil;
import org.hawkular.alerts.rest.TriggersHandler;
import org.jboss.logging.Logger;

@Path(value="/triggers")
@Api(value="/triggers", description="Trigger Handling")
public class TriggersHandler {
    private static final Logger log = Logger.getLogger(TriggersHandler.class);
    @Inject
    Persona persona;
    @EJB
    DefinitionsService definitions;
    ObjectMapper objectMapper;

    public TriggersHandler() {
        log.debugf("Creating instance.", new Object[0]);
        this.objectMapper = new ObjectMapper();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all Trigger definitions", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Triggers list found."), @ApiResponse(code=204, message="Success, Triggers not found."), @ApiResponse(code=500, message="Internal server error")})
    public Response findTriggers() {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Collection triggers = this.definitions.getTriggers(this.persona.getId());
            log.debugf("Triggers: %s ", (Object)triggers);
            if (this.isEmpty(triggers)) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)triggers);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger definitions. If trigger ID is null, a (likely) unique ID will be generated", response=Trigger.class, notes="Returns Trigger created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createTrigger(@ApiParam(value="Trigger definition to be created", name="trigger", required=true) Trigger trigger) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (null != trigger) {
                if (this.isEmpty(trigger.getId())) {
                    trigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(this.persona.getId(), trigger.getId()) != null) {
                    return ResponseUtil.badRequest((String)("Trigger with ID [" + trigger.getId() + "] exists."));
                }
                this.definitions.addTrigger(this.persona.getId(), trigger);
                log.debugf("Trigger: %s ", (Object)trigger.toString());
                return ResponseUtil.ok((Object)trigger);
            }
            return ResponseUtil.badRequest((String)"Trigger is null");
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing trigger definition", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger found"), @ApiResponse(code=404, message="Trigger not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTrigger(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Trigger found = this.definitions.getTrigger(this.persona.getId(), triggerId);
            if (found != null) {
                log.debugf("Trigger: %s ", (Object)found);
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("triggerId: " + triggerId + " not found"));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{triggerId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters")})
    public Response updateTrigger(@ApiParam(value="Trigger definition id to be updated", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Updated trigger definition", name="trigger", required=true) Trigger trigger) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            boolean exists = false;
            if (trigger != null && !this.isEmpty(triggerId)) {
                trigger.setId(triggerId);
                boolean bl = exists = this.definitions.getTrigger(this.persona.getId(), triggerId) != null;
            }
            if (exists) {
                this.definitions.updateTrigger(this.persona.getId(), trigger);
                log.debugf("Trigger: %s ", (Object)trigger);
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}")
    @ApiOperation(value="Delete an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger deleted"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't found")})
    public Response deleteTrigger(@ApiParam(value="Trigger definition id to be deleted", required=true) @PathParam(value="triggerId") String triggerId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (this.definitions.getTrigger(this.persona.getId(), triggerId) != null) {
                this.definitions.removeTrigger(this.persona.getId(), triggerId);
                log.debugf("TriggerId: %s ", (Object)triggerId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Dampenings for a Trigger (1 Dampening per mode).")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampenings found"), @ApiResponse(code=204, message="No Dampenings found for trigger."), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerDampenings(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.persona.getId(), triggerId, null);
            log.debugf("Dampenings: %s ", (Object)dampenings);
            if (dampenings.isEmpty()) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/mode/{triggerMode}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a dampening using triggerId and triggerMode")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening found"), @ApiResponse(code=204, message="No Dampening found for triggerId/triggerMode"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerModeDampenings(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Trigger mode", required=true) @PathParam(value="triggerMode") Trigger.Mode triggerMode) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.persona.getId(), triggerId, triggerMode);
            log.debugf("Dampenings: %s ", (Object)dampenings);
            if (dampenings.isEmpty()) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing dampening")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Found"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Dampening found = this.definitions.getDampening(this.persona.getId(), dampeningId);
            log.debugf("Dampening: %s ", (Object)found);
            if (found == null) {
                return ResponseUtil.notFound((String)("No dampening found for triggerId: " + triggerId + " and dampeningId:" + dampeningId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/{triggerId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new dampening", notes="Returns Dampening created if operation finishes correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createDampening(@ApiParam(value="Trigger definition id attached to dampening", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening definition to be created", required=true) Dampening dampening) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            boolean exists;
            dampening.setTriggerId(triggerId);
            boolean bl = exists = this.definitions.getDampening(triggerId, dampening.getDampeningId()) != null;
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.addDampening(this.persona.getId(), d);
                log.debugf("Dampening: %s ", (Object)d);
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.badRequest((String)("Existing dampening for dampeningId: " + dampening.getDampeningId()));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private Dampening getCleanDampening(Dampening dampening) throws Exception {
        switch (1.$SwitchMap$org$hawkular$alerts$api$model$dampening$Dampening$Type[dampening.getType().ordinal()]) {
            case 1: {
                return Dampening.forStrict((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting());
            }
            case 2: {
                return Dampening.forStrictTime((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 3: {
                return Dampening.forStrictTimeout((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 4: {
                return Dampening.forRelaxedCount((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (int)dampening.getEvalTotalSetting());
            }
            case 5: {
                return Dampening.forRelaxedTime((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (long)dampening.getEvalTimeSetting());
            }
        }
        throw new Exception("Unhandled Dampening Type: " + dampening.toString());
    }

    @PUT
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing dampening definition. Note that the trigger mode can not be changed.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition", required=true) Dampening dampening) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.persona.getId(), dampeningId) != null;
            if (exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateDampening(this.persona.getId(), d);
                log.debugf("Dampening: %s ", (Object)d);
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.notFound((String)("No dampening found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing dampening definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening deleted"), @ApiResponse(code=404, message="No Dampening found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id for dampening definition to be deleted", required=true) @PathParam(value="dampeningId") String dampeningId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.persona.getId(), dampeningId) != null;
            if (exists) {
                this.definitions.removeDampening(this.persona.getId(), dampeningId);
                log.debugf("DampeningId: %s ", (Object)dampeningId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Dampening not found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map with all conditions for a specific trigger.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Conditions found"), @ApiResponse(code=204, message="Success, no Conditions found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerConditions(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Collection conditions = this.definitions.getTriggerConditions(this.persona.getId(), triggerId, null);
            log.debugf("Conditions: %s ", (Object)conditions);
            if (this.isEmpty(conditions)) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a condition for a specific trigger id.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition found"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Trigger trigger = this.definitions.getTrigger(this.persona.getId(), triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition found = this.definitions.getCondition(this.persona.getId(), conditionId);
            if (found == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!found.getTriggerId().equals(triggerId)) {
                return ResponseUtil.notFound((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new condition for a specific trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition created"), @ApiResponse(code=404, message="No trigger found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Json representation of a condition. For examples of Condition types, See https://github.com/hawkular/hawkular-alerts/blob/master/hawkular-alerts-rest-tests/src/test/groovy/org/hawkular/alerts/rest/ConditionsITest.groovy") String jsonCondition) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Trigger trigger = this.definitions.getTrigger(this.persona.getId(), triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                return ResponseUtil.badRequest((String)"json condition empty or without type");
            }
            Condition.Type conditionType = this.conditionType(jsonCondition);
            if (conditionType == null || this.isEmpty(triggerId)) {
                return ResponseUtil.badRequest((String)"Bad type in json condition");
            }
            Condition condition = null;
            if (conditionType.equals((Object)Condition.Type.AVAILABILITY)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, AvailabilityCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.COMPARE)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, CompareCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.STRING)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, StringCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.THRESHOLD)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.RANGE)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdRangeCondition.class);
            }
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            Collection conditions = this.definitions.addCondition(this.persona.getId(), condition.getTriggerId(), condition.getTriggerMode(), condition);
            log.debugf("Conditions: %s ", (Object)conditions);
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing condition for a specific trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition updated"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response updateCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId, @ApiParam(value="Json representation of a condition") String jsonCondition) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Trigger trigger = this.definitions.getTrigger(this.persona.getId(), triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                return ResponseUtil.badRequest((String)"json condition empty or without type");
            }
            Condition.Type conditionType = this.conditionType(jsonCondition);
            if (conditionType == null || this.isEmpty(conditionId)) {
                return ResponseUtil.badRequest((String)"Bad type in json condition");
            }
            Condition condition = null;
            if (conditionType.equals((Object)Condition.Type.AVAILABILITY)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, AvailabilityCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.COMPARE)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, CompareCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.STRING)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, StringCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.THRESHOLD)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdCondition.class);
            } else if (conditionType.equals((Object)Condition.Type.RANGE)) {
                condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdRangeCondition.class);
            }
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            boolean exists = false;
            if (conditionId.equals(condition.getConditionId())) {
                boolean bl = exists = this.definitions.getCondition(this.persona.getId(), condition.getConditionId()) != null;
            }
            if (!exists) {
                return ResponseUtil.notFound((String)("Condition not found for conditionId: " + conditionId));
            }
            Collection conditions = this.definitions.updateCondition(this.persona.getId(), condition);
            log.debugf("Conditions: %s ", (Object)conditions);
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete an existing condition for a specific trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition deleted"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response deleteCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Trigger trigger = this.definitions.getTrigger(this.persona.getId(), triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition condition = this.definitions.getCondition(this.persona.getId(), conditionId);
            if (condition == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!condition.getTriggerId().equals(triggerId)) {
                return ResponseUtil.badRequest((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            Collection conditions = this.definitions.removeCondition(this.persona.getId(), conditionId);
            log.debugf("Conditions: %s ", (Object)conditions);
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private Condition.Type conditionType(String jsonCondition) {
        int startType = jsonCondition.indexOf("\"type\"") + 6;
        int endType = jsonCondition.indexOf(",", startType);
        if (endType == -1 && (endType = jsonCondition.indexOf("}", startType)) == -1) {
            return null;
        }
        String type = jsonCondition.substring(startType, endType);
        startType = type.indexOf(34) + 1;
        endType = type.indexOf(34, startType);
        type = type.substring(startType, endType);
        try {
            return Condition.Type.valueOf((String)type);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return null;
        }
    }

    @POST
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger tag", notes="Returns Tag created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tag created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createTag(@ApiParam(value="Tag to be created", required=true) Tag tag) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (this.isEmpty(tag.getTriggerId()) || this.isEmpty(tag.getName())) {
                return ResponseUtil.badRequest((String)"Invalid tag, triggerId or name required");
            }
            this.definitions.addTag(this.persona.getId(), tag);
            log.debugf("Tag: %s ", (Object)tag);
            return ResponseUtil.ok((Object)tag);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/{triggerId}/tags")
    @ApiOperation(value="Delete existing Tags from a Trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tags deleted"), @ApiResponse(code=404, message="No Trigger Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response deleteTags(@ApiParam(value="Trigger id of tags to be deleted", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Category of tags to be deleted", required=false) @QueryParam(value="category") String category, @ApiParam(value="Name of tags to be deleted", required=false) @QueryParam(value="name") String name) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            this.definitions.removeTags(this.persona.getId(), triggerId, category, name);
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get tags for a trigger.", responseContainer="Collection<Tag>", response=Tag.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tags found"), @ApiResponse(code=204, message="No Tags found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response getTriggerTags(@ApiParam(value="Trigger id for the retrieved Tags", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Category of tags to be retrieved", required=false) @QueryParam(value="category") String category) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            List tags = this.definitions.getTriggerTags(this.persona.getId(), triggerId, category);
            log.debugf("Tags: " + tags, new Object[0]);
            if (this.isEmpty((Collection)tags)) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)tags);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private boolean checkPersona() {
        if (this.persona == null) {
            log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (this.isEmpty(this.persona.getId())) {
            log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

