/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.data.MixedData;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/")
@Api(value="/", description="Alert Handling")
public class AlertsHandler {
    private final Logger log = Logger.getLogger(AlertsHandler.class);
    @Inject
    Persona persona;
    @EJB
    AlertsService alertsService;
    @EJB
    AlertsEngine alertsEngine;

    public AlertsHandler() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get alerts with optional filtering", notes="Pagination is not yet implemented.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response findAlerts(@ApiParam(required=false, value="filter out alerts created before this time, millisecond since epoch") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="filter out alerts created after this time, millisecond since epoch") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="filter out alerts for unspecified alertIds, comma separated list of alert IDs") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="filter out alerts for unspecified triggers, comma separated list of trigger IDs") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="filter out alerts for unspecified lifecycle status, comma separated list of status values") @QueryParam(value="statuses") String statuses, @ApiParam(required=false, value="filter out alerts for unspecified severity, comma separated list of severity values") @QueryParam(value="severities") String severities, @ApiParam(required=false, value="filter out alerts for unspecified tags, comma separated list of tags, each tag of format [category|]name") @QueryParam(value="tags") String tags, @ApiParam(required=false, value="return only thin alerts, do not include: evalSets, resolvedEvalSets") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            AlertsCriteria criteria = this.buildCriteria(startTime, endTime, alertIds, triggerIds, statuses, severities, tags, thin);
            Page alertPage = this.alertsService.getAlerts(this.persona.getId(), criteria, pager);
            this.log.debugf("Alerts: %s ", (Object)alertPage);
            if (this.isEmpty((Collection)alertPage)) {
                return ResponseUtil.ok((Object)alertPage);
            }
            return ResponseUtil.paginatedOk((Page)alertPage, (UriInfo)uri);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/ack/{alertId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one alert Acknowledged")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert Acknowledged invoked successfully"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response ackAlert(@ApiParam(required=true, value="alertId to Ack") @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="user acknowledging the alerts") @QueryParam(value="ackBy") String ackBy, @ApiParam(required=false, value="additional notes asscoiated with the acknowledgement") @QueryParam(value="ackNotes") String ackNotes) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (!this.isEmpty(alertId)) {
                this.alertsService.ackAlerts(this.persona.getId(), Arrays.asList(alertId), ackBy, ackNotes);
                this.log.debugf("AlertId: %s ", (Object)alertId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertId required for ack");
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/ack")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts Acknowledged")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Acknowledged invoked successfully"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response ackAlerts(@ApiParam(required=true, value="comma separated list of alertIds to Ack") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="user acknowledging the alerts") @QueryParam(value="ackBy") String ackBy, @ApiParam(required=false, value="additional notes asscoiated with the acknowledgement") @QueryParam(value="ackNotes") String ackNotes) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (!this.isEmpty(alertIds)) {
                this.alertsService.ackAlerts(this.persona.getId(), Arrays.asList(alertIds.split(",")), ackBy, ackNotes);
                this.log.debugf("Acked alertIds: %s ", (Object)alertIds);
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertIds required for ack");
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{alertId}")
    @ApiOperation(value="Delete an existing Alert")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert deleted"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Alert not found")})
    public Response deleteAlert(@ApiParam(value="Alert id to be deleted", required=true) @PathParam(value="alertId") String alertId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            AlertsCriteria criteria = new AlertsCriteria();
            criteria.setAlertId(alertId);
            int numDeleted = this.alertsService.deleteAlerts(this.persona.getId(), criteria);
            if (1 == numDeleted) {
                this.log.debugf("AlertId: %s ", (Object)alertId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Alert " + alertId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete alerts with optional filtering")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteAlerts(@ApiParam(required=false, value="filter out alerts created before this time, millisecond since epoch") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="filter out alerts created after this time, millisecond since epoch") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="filter out alerts for unspecified alertIds, comma separated list of alert IDs") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="filter out alerts for unspecified triggers, comma separated list of trigger IDs") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="filter out alerts for unspecified lifecycle status, comma separated list of status values") @QueryParam(value="statuses") String statuses, @ApiParam(required=false, value="filter out alerts for unspecified severity, comma separated list of severity values") @QueryParam(value="severities") String severities, @ApiParam(required=false, value="filter out alerts for unspecified tags, comma separated list of tags, each tag of format [category|]name") @QueryParam(value="tags") String tags) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            AlertsCriteria criteria = this.buildCriteria(startTime, endTime, alertIds, triggerIds, statuses, severities, tags, null);
            int numDeleted = this.alertsService.deleteAlerts(this.persona.getId(), criteria);
            this.log.debugf("Alerts deleted: %s ", numDeleted);
            return ResponseUtil.ok((Object)numDeleted);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private AlertsCriteria buildCriteria(Long startTime, Long endTime, String alertIds, String triggerIds, String statuses, String severities, String tags, Boolean thin) {
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setStartTime(startTime);
        criteria.setEndTime(endTime);
        if (!this.isEmpty(alertIds)) {
            criteria.setAlertIds(Arrays.asList(alertIds.split(",")));
        }
        if (!this.isEmpty(triggerIds)) {
            criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!this.isEmpty(statuses)) {
            HashSet<Alert.Status> statusSet = new HashSet<Alert.Status>();
            for (String s : statuses.split(",")) {
                statusSet.add(Alert.Status.valueOf((String)s));
            }
            criteria.setStatusSet(statusSet);
        }
        if (null != severities && !severities.trim().isEmpty()) {
            HashSet<Severity> severitySet = new HashSet<Severity>();
            for (String s : severities.split(",")) {
                severitySet.add(Severity.valueOf((String)s));
            }
            criteria.setSeverities(severitySet);
        }
        if (!this.isEmpty(tags)) {
            String[] tagTokens = tags.split(",");
            ArrayList<Tag> tagList = new ArrayList<Tag>(tagTokens.length);
            for (String tagToken : tagTokens) {
                String[] fields = tagToken.split("\\|");
                if (fields.length <= 0 || fields.length >= 3) continue;
                Tag newTag = fields.length == 1 ? new Tag(fields[0]) : new Tag(fields[0], fields[1]);
                newTag.setTenantId(this.persona.getId());
                tagList.add(newTag);
            }
            criteria.setTags(tagList);
        }
        if (null != thin) {
            criteria.setThin(thin.booleanValue());
        }
        return criteria;
    }

    @GET
    @Path(value="/alert/{alertId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing Alert", response=Alert.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert found"), @ApiResponse(code=404, message="Alert not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAlert(@ApiParam(value="Id of alert to be retrieved", required=true) @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="return only a thin alert, do not include: evalSets, resolvedEvalSets") @QueryParam(value="thin") Boolean thin) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Alert found = this.alertsService.getAlert(this.persona.getId(), alertId, null == thin ? false : thin);
            if (found != null) {
                this.log.debugf("Alert: %s ", (Object)found);
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("alertId: " + alertId + " not found"));
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/resolve/{alertId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one alert Resolved")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Resolution invoked successfully."), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response resolveAlert(@ApiParam(required=true, value="alertId to set Resolved") @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="user resolving the alerts") @QueryParam(value="resolvedBy") String resolvedBy, @ApiParam(required=false, value="additional notes asscoiated with the resolution") @QueryParam(value="resolvedNotes") String resolvedNotes) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (!this.isEmpty(alertId)) {
                this.alertsService.resolveAlerts(this.persona.getId(), Arrays.asList(alertId), resolvedBy, resolvedNotes, null);
                this.log.debugf("AlertId: %s ", (Object)alertId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertsId required for resolve");
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/resolve")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts Resolved")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Resolution invoked successfully."), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response resolveAlerts(@ApiParam(required=true, value="comma separated list of alertIds to set Resolved") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="user resolving the alerts") @QueryParam(value="resolvedBy") String resolvedBy, @ApiParam(required=false, value="additional notes asscoiated with the resolution") @QueryParam(value="resolvedNotes") String resolvedNotes) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (!this.isEmpty(alertIds)) {
                this.alertsService.resolveAlerts(this.persona.getId(), Arrays.asList(alertIds.split(",")), resolvedBy, resolvedNotes, null);
                this.log.debugf("AlertsIds: %s ", (Object)alertIds);
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertsIds required for resolve");
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/data")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Send data for alert processing/condition evaluation.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, data added."), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response sendData(@ApiParam(required=true, name="mixedData", value="data to be processed by alerting") MixedData mixedData) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            if (this.isEmpty(mixedData)) {
                return ResponseUtil.badRequest((String)"Data is empty");
            }
            this.alertsEngine.sendData(mixedData.asCollection());
            this.log.debugf("MixedData: %s ", (Object)mixedData);
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/reload")
    @ApiOperation(value="Reload all definitions into the alerts service", notes="This service is temporal for demos/poc, this functionality will be handled internallybetween definitions and alerts services")
    @ApiResponses(value={@ApiResponse(code=200, message="Success. Reload invoked successfully."), @ApiResponse(code=500, message="Internal server error")})
    public Response reloadAlerts() {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            this.alertsEngine.reload();
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/reload/{triggerId}")
    @ApiOperation(value="Reload a specific trigger into the alerts service")
    @ApiResponses(value={@ApiResponse(code=200, message="Success. Reload invoked successfully."), @ApiResponse(code=500, message="Internal server error")})
    public Response reloadTrigger(@PathParam(value="triggerId") String triggerId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            this.alertsEngine.reloadTrigger(this.persona.getId(), triggerId);
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private boolean checkPersona() {
        if (this.persona == null) {
            this.log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (this.isEmpty(this.persona.getId())) {
            this.log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEmpty(MixedData data) {
        return data == null || data.isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

