/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.services.ActionsCriteria;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/actions")
@Api(value="/actions", description="Action Handling")
public class ActionsHandler {
    private final Logger log = Logger.getLogger(ActionsHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public ActionsHandler() {
        this.log.debug((Object)"Creating instance.");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids grouped by plugin", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success."), @ApiResponse(code=500, message="Internal server error")})
    public Response findActions() {
        try {
            Map actions = this.definitions.getActions(this.tenantId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actions));
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/plugin/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids of an specific action plugin", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response findActionsByPlugin(@ApiParam(value="Action plugin to filter query for action ids", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        try {
            Collection actions = this.definitions.getActions(this.tenantId, actionPlugin);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actions));
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new action", notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Existing action/Invalid Parameters")})
    public Response createAction(@ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", name="actionProperties", required=true) Map<String, String> actionProperties) {
        String actionPlugin = actionProperties.get("actionPlugin");
        String actionId = actionProperties.get("actionId");
        if (this.isEmpty(actionPlugin)) {
            return ResponseUtil.badRequest((String)"actionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            return ResponseUtil.badRequest((String)"actionId must be not null");
        }
        try {
            if (this.definitions.getAction(this.tenantId, actionPlugin, actionId) != null) {
                return ResponseUtil.badRequest((String)("Existing action:  " + actionId));
            }
            this.definitions.addAction(this.tenantId, actionPlugin, actionId, actionProperties);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionId: " + actionId + " - Properties: " + actionProperties));
            }
            return ResponseUtil.ok(actionProperties);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{actionPlugin}/{actionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing action", responseContainer="Map<String, String>", response=String.class, notes="Action is represented as a map of properties.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Found"), @ApiResponse(code=404, message="No Action Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be retrieved", required=true) @PathParam(value="actionId") String actionId) {
        try {
            Map actionProperties = this.definitions.getAction(this.tenantId, actionPlugin, actionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionId: " + actionId + " - Properties: " + actionProperties));
            }
            if (this.isEmpty(actionProperties)) {
                return ResponseUtil.notFound((String)("Not action found for actionPlugin: " + actionPlugin + " and actionId: " + actionId));
            }
            return ResponseUtil.ok((Object)actionProperties);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{actionPlugin}/{actionId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing action", notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Action not found for update")})
    public Response updateAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="action id to be updated", required=true) @PathParam(value="actionId") String actionId, @ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", required=true) Map<String, String> actionProperties) {
        try {
            if (this.definitions.getAction(this.tenantId, actionPlugin, actionId) != null) {
                this.definitions.updateAction(this.tenantId, actionPlugin, actionId, actionProperties);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionId: " + actionId + " - Properties:  " + actionProperties));
                }
                return ResponseUtil.ok(actionProperties);
            }
            return ResponseUtil.notFound((String)("ActionId: " + actionId + " not found for update"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{actionPlugin}/{actionId}")
    @ApiOperation(value="Delete an existing action")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Deleted"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="ActionId not found for delete")})
    public Response deleteAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be deleted", required=true) @PathParam(value="actionId") String actionId) {
        try {
            if (this.definitions.getAction(this.tenantId, actionPlugin, actionId) != null) {
                this.definitions.removeAction(this.tenantId, actionPlugin, actionId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionId: " + actionId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("ActionId: " + actionId + " not found for delete"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get actions from history with optional filtering")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response findActionsHistory(@ApiParam(required=false, value="filter out actions created before this time, millisecond since epoch") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="filter out action created after this time, millisecond since epoch") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="filter out actions for unspecified actionPlugin, comma separated list of plugin names") @QueryParam(value="actionPlugins") String actionPlugins, @ApiParam(required=false, value="filter out actions for unspecified actionId, comma separated list of action IDs") @QueryParam(value="actionIds") String actionIds, @ApiParam(required=false, value="filter out actions for unspecified alertIds, comma separated list of alert IDs") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="filter out alerts for unspecified result, comma separated list of action results") @QueryParam(value="results") String results, @ApiParam(required=false, value="return only thin actions, do not include full alert, only alertId") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            ActionsCriteria criteria = this.buildCriteria(startTime, endTime, actionPlugins, actionIds, alertIds, results, thin);
            Page actionPage = this.actions.getActions(this.tenantId, criteria, pager);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actionPage));
            }
            if (this.isEmpty((Collection)actionPage)) {
                return ResponseUtil.ok((Object)actionPage);
            }
            return ResponseUtil.paginatedOk((Page)actionPage, (UriInfo)uri);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/history/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete actions from history with optional filtering")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteActionsHistory(@ApiParam(required=false, value="filter out actions created before this time, millisecond since epoch") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="filter out action created after this time, millisecond since epoch") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="filter out actions for unspecified actionPlugin, comma separated list of plugin names") @QueryParam(value="actionPlugins") String actionPlugins, @ApiParam(required=false, value="filter out actions for unspecified actionId, comma separated list of action IDs") @QueryParam(value="actionIds") String actionIds, @ApiParam(required=false, value="filter out actions for unspecified alertIds, comma separated list of alert IDs") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="filter out alerts for unspecified result, comma separated list of action results") @QueryParam(value="results") String results) {
        try {
            ActionsCriteria criteria = this.buildCriteria(startTime, endTime, actionPlugins, actionIds, alertIds, results, Boolean.valueOf(false));
            int numDeleted = this.actions.deleteActions(this.tenantId, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions deleted: " + numDeleted));
            }
            return ResponseUtil.ok((Object)numDeleted);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private ActionsCriteria buildCriteria(Long startTime, Long endTime, String actionPlugins, String actionIds, String alertIds, String results, Boolean thin) {
        ActionsCriteria criteria = new ActionsCriteria();
        criteria.setStartTime(startTime);
        criteria.setEndTime(endTime);
        if (!this.isEmpty(actionPlugins)) {
            criteria.setActionPlugins(Arrays.asList(actionPlugins.split(",")));
        }
        if (!this.isEmpty(actionIds)) {
            criteria.setActionIds(Arrays.asList(actionPlugins.split(",")));
        }
        if (!this.isEmpty(alertIds)) {
            criteria.setAlertIds(Arrays.asList(alertIds.split(",")));
        }
        if (!this.isEmpty(results)) {
            criteria.setResults(Arrays.asList(results.split(",")));
        }
        if (thin != null) {
            criteria.setThin(thin.booleanValue());
        } else {
            criteria.setThin(false);
        }
        return criteria;
    }

    private boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

