/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ejb.EJB;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.export.Definitions;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/export")
@Api(value="/export", description="Export of triggers and actions definitions")
public class ExportHandler {
    private final Logger log = Logger.getLogger(ExportHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Export a list of full triggers and action definitions.", response=Definitions.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully exported list of full triggers and action definitions."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response exportDefinitions() {
        try {
            Definitions definitions = this.definitions.exportDefinitions(this.tenantId);
            return ResponseUtil.ok((Object)definitions);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }
}

