/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest.json;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.alerts.rest.json.LinkDeserializer;
import org.hawkular.alerts.rest.json.LinkSerializer;

@ApiModel(value="Link between two resources")
@XmlRootElement
@JsonSerialize(using=LinkSerializer.class)
@JsonDeserialize(using=LinkDeserializer.class)
@Produces(value={"application/json", "application/xml"})
public class Link {
    private String rel;
    private String href;

    public Link() {
    }

    public Link(String rel, String href) {
        this.rel = rel;
        this.href = href;
    }

    @ApiModelProperty(value="Name of the relation")
    @XmlAttribute
    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    @ApiModelProperty(value="Target of the relation")
    @XmlAttribute
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String toString() {
        return this.href + "; " + "rel='" + this.rel + '\'';
    }

    public String rfc5988String() {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(this.href).append(">; rel=\"").append(this.rel).append("\"");
        return builder.toString();
    }
}

