/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing.propagation.apache;

import io.opentracing.propagation.TextMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;

public final class HttpMessageInjectAdapter
implements TextMap {
    private static final Logger log = Logger.getLogger(HttpMessageInjectAdapter.class.getName());
    private final Object message;
    private static Method method;

    public HttpMessageInjectAdapter(Object message) {
        this.message = message;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("HttpMessageInjectAdapter should only be used with Tracer.inject()");
    }

    @Override
    public void put(String key, String value) {
        try {
            if (method == null) {
                Class<?> cls = this.message.getClass();
                method = cls.getMethod("addHeader", String.class, String.class);
            }
            method.invoke(this.message, key, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException t) {
            log.log(Logger.Level.WARNING, "Failed to add header key=" + key + " value=" + value, t);
        }
    }
}

