/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.utils;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.Node;

public class NodeUtil {
    private static final String APM_ORIGINAL_URI = "apm_original_uri";

    public static boolean isURIRewritten(Node node) {
        return node.hasProperty(APM_ORIGINAL_URI);
    }

    public static void rewriteURI(Node node, String uri) {
        node.getProperties().add(new Property(APM_ORIGINAL_URI, node.getUri()));
        node.setUri(uri);
    }

    public static boolean isOriginalURI(Node node, String uri) {
        if (node.getUri().equals(uri)) {
            return true;
        }
        if (node.hasProperty(APM_ORIGINAL_URI)) {
            return node.getProperties(APM_ORIGINAL_URI).iterator().next().getValue().equals(uri);
        }
        return false;
    }

    public static <T extends Node> List<T> findNodes(List<Node> nodes, Class<T> cls) {
        ArrayList results = new ArrayList();
        NodeUtil.findNodes(nodes, cls, results);
        return results;
    }

    public static <T extends Node> void findNodes(List<Node> nodes, Class<T> cls, List<T> results) {
        for (Node n : nodes) {
            if (n instanceof ContainerNode) {
                NodeUtil.findNodes(((ContainerNode)n).getNodes(), cls, results);
            }
            if (cls != n.getClass()) continue;
            results.add(n);
        }
    }
}

