/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.api.sampler;

import java.util.BitSet;
import java.util.Random;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.client.api.sampler.Sampler;

public class PercentageSampler
implements Sampler {
    private BitSet bitSet;
    private int i;

    protected PercentageSampler(int percentage) {
        this.bitSet = PercentageSampler.randomBitSet(100, percentage, new Random());
    }

    public static Sampler withPercentage(int percentage) {
        if (percentage <= 0) {
            return Sampler.NEVER_SAMPLE;
        }
        if (percentage >= 100) {
            return Sampler.ALWAYS_SAMPLE;
        }
        return new PercentageSampler(percentage);
    }

    @Override
    public synchronized boolean isSampled(Trace trace) {
        boolean sample = this.bitSet.get(this.i++);
        this.i = this.i == 100 ? 0 : this.i;
        return sample;
    }

    private static BitSet randomBitSet(int size, int cardinality, Random random) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        for (i = cardinality; i < size; ++i) {
            int j = random.nextInt(i + 1);
            if (j >= cardinality) continue;
            result.clear(chosen[j]);
            result.set(i);
            chosen[j] = i;
        }
        return result;
    }
}

