/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import org.hawkular.apm.api.utils.PropertyUtil;

public class DeploymentMetaData {
    private static String ENV_SERVICE_NAME = DeploymentMetaData.getServiceNameFromEnv();
    private static String ENV_BUILD_STAMP = DeploymentMetaData.getBuildStampFromEnv();
    private static DeploymentMetaData INSTANCE = new DeploymentMetaData(ENV_SERVICE_NAME, ENV_BUILD_STAMP);
    private String serviceName;
    private String buildStamp;

    public DeploymentMetaData(String serviceName, String buildStamp) {
        this.serviceName = serviceName;
        this.buildStamp = buildStamp;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getBuildStamp() {
        return this.buildStamp;
    }

    public void setBuildStamp(String buildStamp) {
        this.buildStamp = buildStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentMetaData that = (DeploymentMetaData)o;
        if (!this.serviceName.equals(that.serviceName)) {
            return false;
        }
        return this.buildStamp.equals(that.buildStamp);
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.buildStamp.hashCode();
        return result;
    }

    public String toString() {
        return "DeploymentMetaData{serviceName='" + this.serviceName + '\'' + ", buildStamp='" + this.buildStamp + '\'' + '}';
    }

    static String getBuildStampFromEnv() {
        String buildName = PropertyUtil.getProperty("OPENSHIFT_BUILD_NAME");
        if (null != buildName && !buildName.isEmpty()) {
            String buildNamespace = PropertyUtil.getProperty("OPENSHIFT_BUILD_NAMESPACE");
            if (null == buildNamespace || buildNamespace.isEmpty()) {
                return buildName;
            }
            return String.format("%s.%s", buildNamespace, buildName);
        }
        return null;
    }

    static String getServiceNameFromEnv() {
        String serviceName = PropertyUtil.getProperty("HAWKULAR_APM_SERVICE_NAME");
        if (null == serviceName || serviceName.isEmpty()) {
            String buildStamp = DeploymentMetaData.getBuildStampFromEnv();
            if (null != buildStamp && !buildStamp.isEmpty()) {
                return DeploymentMetaData.getServiceFromBuildName(buildStamp);
            }
            return null;
        }
        return serviceName;
    }

    static String getServiceFromBuildName(String buildName) {
        if (null == buildName || buildName.isEmpty()) {
            return buildName;
        }
        return buildName.substring(0, buildName.lastIndexOf(45));
    }

    static void reloadServiceName() {
        ENV_SERVICE_NAME = DeploymentMetaData.getServiceNameFromEnv();
        ENV_BUILD_STAMP = DeploymentMetaData.getBuildStampFromEnv();
        INSTANCE = new DeploymentMetaData(ENV_SERVICE_NAME, ENV_BUILD_STAMP);
    }

    static DeploymentMetaData getInstance() {
        return INSTANCE;
    }
}

