/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing;

import io.opentracing.APMSpanBuilder;
import io.opentracing.AbstractSpan;
import io.opentracing.AbstractSpanBuilder;
import io.opentracing.PropagableState;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.ReportingLevel;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.api.utils.TimeUtil;
import org.hawkular.apm.client.api.recorder.TraceRecorder;
import org.hawkular.apm.client.api.sampler.ContextSampler;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.TraceContext;

public class APMSpan
extends AbstractSpan
implements PropagableState {
    private static final Logger log = Logger.getLogger(APMSpan.class.getName());
    private TraceContext traceContext;
    private NodeBuilder nodeBuilder;
    private String nodePath;
    private String interactionId;

    public APMSpan(APMSpanBuilder builder, TraceRecorder recorder, ContextSampler sampler) {
        super(builder.operationName, builder.start);
        this.init(builder, recorder, sampler);
    }

    protected void init(APMSpanBuilder builder, TraceRecorder recorder, ContextSampler sampler) {
        if (!builder.references.isEmpty()) {
            this.initReferences(builder, recorder, sampler);
        }
        if (this.nodeBuilder == null) {
            this.initTopLevelState(this, recorder, sampler);
        }
        this.nodePath = this.nodeBuilder.getNodePath();
        this.traceContext.startProcessingNode();
    }

    protected void initReferences(APMSpanBuilder builder, TraceRecorder recorder, ContextSampler sampler) {
        AbstractSpanBuilder.Reference primaryRef = APMSpan.findPrimaryReference(builder.references);
        if (primaryRef != null) {
            if (primaryRef.getReferredTo() instanceof APMSpanBuilder) {
                this.initFromExtractedTraceState(builder, recorder, primaryRef, sampler);
            } else if (primaryRef.getReferredTo() instanceof APMSpan) {
                if ("child_of".equals(primaryRef.getReferenceType())) {
                    this.initChildOf(builder, primaryRef);
                } else if ("follows_from".equals(primaryRef.getReferenceType())) {
                    this.initFollowsFrom(builder, recorder, primaryRef, sampler);
                }
            }
        } else {
            this.processNoPrimaryReference(builder, recorder, sampler);
        }
    }

    public static AbstractSpanBuilder.Reference findPrimaryReference(List<AbstractSpanBuilder.Reference> references) {
        List followsFrom = references.stream().filter(ref -> "follows_from".equals(ref.getReferenceType()) && ref.getReferredTo() instanceof APMSpan).collect(Collectors.toList());
        List childOfSpan = references.stream().filter(ref -> "child_of".equals(ref.getReferenceType()) && ref.getReferredTo() instanceof APMSpan).collect(Collectors.toList());
        List extractedTraceState = references.stream().filter(ref -> ref.getReferredTo() instanceof APMSpanBuilder).collect(Collectors.toList());
        if (!extractedTraceState.isEmpty()) {
            if (extractedTraceState.size() == 1) {
                return (AbstractSpanBuilder.Reference)extractedTraceState.get(0);
            }
            return null;
        }
        if (!childOfSpan.isEmpty()) {
            if (childOfSpan.size() == 1) {
                return (AbstractSpanBuilder.Reference)childOfSpan.get(0);
            }
            return null;
        }
        if (followsFrom.size() == 1) {
            return (AbstractSpanBuilder.Reference)followsFrom.get(0);
        }
        return null;
    }

    protected void initTopLevelState(APMSpan topSpan, TraceRecorder recorder, ContextSampler sampler) {
        this.nodeBuilder = new NodeBuilder();
        this.traceContext = new TraceContext(topSpan, this.nodeBuilder, recorder, sampler);
    }

    protected void initFromExtractedTraceState(APMSpanBuilder builder, TraceRecorder recorder, AbstractSpanBuilder.Reference ref, ContextSampler sampler) {
        APMSpanBuilder parentBuilder = (APMSpanBuilder)ref.getReferredTo();
        this.initTopLevelState(this, recorder, sampler);
        if (parentBuilder.state().containsKey("HWKAPMID")) {
            this.setInteractionId(parentBuilder.state().get("HWKAPMID").toString());
            this.traceContext.initTraceState(parentBuilder.state());
        }
        this.getNodeBuilder().setNodeType(NodeType.Consumer);
        this.processRemainingReferences(builder, ref);
    }

    protected void initChildOf(APMSpanBuilder builder, AbstractSpanBuilder.Reference ref) {
        APMSpan parent = (APMSpan)ref.getReferredTo();
        if (parent.getNodeBuilder() != null) {
            this.nodeBuilder = new NodeBuilder(parent.getNodeBuilder());
            this.traceContext = parent.traceContext;
            if (parent.getTags().containsKey("transaction") && this.traceContext.getTransaction() == null) {
                this.traceContext.setTransaction(parent.getTags().get("transaction").toString());
            }
        }
        this.processRemainingReferences(builder, ref);
    }

    protected void initFollowsFrom(APMSpanBuilder builder, TraceRecorder recorder, AbstractSpanBuilder.Reference ref, ContextSampler sampler) {
        APMSpan referenced = (APMSpan)ref.getReferredTo();
        this.initTopLevelState(referenced.getTraceContext().getTopSpan(), recorder, sampler);
        String nodeId = referenced.getNodePath();
        this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.CausedBy, nodeId));
        this.traceContext.initTraceState(referenced.state());
        this.makeInternalLink(builder);
    }

    protected void processNoPrimaryReference(APMSpanBuilder builder, TraceRecorder recorder, ContextSampler sampler) {
        this.initTopLevelState(this, recorder, sampler);
        Set traceIds = builder.references.stream().map(ref -> {
            if (ref.getReferredTo() instanceof APMSpan) {
                return ((APMSpan)ref.getReferredTo()).getTraceContext().getTraceId();
            }
            if (ref.getReferredTo() instanceof APMSpanBuilder) {
                return ((APMSpanBuilder)ref.getReferredTo()).state().get("HWKAPMTRACEID").toString();
            }
            log.warning("Reference refers to an unsupported SpanContext implementation: " + ref.getReferredTo());
            return null;
        }).collect(Collectors.toSet());
        if (traceIds.size() > 0) {
            if (traceIds.size() > 1) {
                log.warning("References should all belong to the same 'trace' instance");
            }
            if (((AbstractSpanBuilder.Reference)builder.references.get(0)).getReferredTo() instanceof APMSpan) {
                this.traceContext.initTraceState(((APMSpan)((AbstractSpanBuilder.Reference)builder.references.get(0)).getReferredTo()).state());
            }
        }
        this.processRemainingReferences(builder, null);
        this.makeInternalLink(builder);
    }

    protected void processRemainingReferences(APMSpanBuilder builder, AbstractSpanBuilder.Reference primaryRef) {
        for (AbstractSpanBuilder.Reference ref : builder.references) {
            if (primaryRef == ref) continue;
            if (ref.getReferredTo() instanceof APMSpan) {
                APMSpan referenced = (APMSpan)ref.getReferredTo();
                String nodeId = referenced.getNodePath();
                this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.CausedBy, nodeId));
                continue;
            }
            if (!(ref.getReferredTo() instanceof APMSpanBuilder) || !((APMSpanBuilder)ref.getReferredTo()).state().containsKey("HWKAPMID")) continue;
            this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, ((APMSpanBuilder)ref.getReferredTo()).state().get("HWKAPMID").toString()));
        }
    }

    protected void makeInternalLink(APMSpanBuilder builder) {
        this.getNodeBuilder().setNodeType(NodeType.Consumer);
        this.getNodeBuilder().setEndpointType(null);
        EndpointRef epref = this.getTraceContext().getSourceEndpoint();
        this.getNodeBuilder().setUri(epref.getUri());
        this.getNodeBuilder().setOperation(epref.getOperation());
        this.getNodeBuilder().setTimestamp(TimeUtil.toMicros(builder.start));
        this.nodeBuilder = new NodeBuilder(this.getNodeBuilder());
    }

    protected void setInteractionId(String id) {
        this.interactionId = id;
        this.getNodeBuilder().addCorrelationId(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
    }

    protected String getInteractionId() {
        return this.interactionId;
    }

    protected String getNodePath() {
        return this.nodePath;
    }

    @Override
    public void finish() {
        if (!this.isCompleted()) {
            super.finish();
            this.completeNode();
        }
    }

    @Override
    public void finish(long finishMicros) {
        if (!this.isCompleted()) {
            super.finish(finishMicros);
            this.completeNode();
        }
    }

    private void completeNode() {
        if (this.nodeBuilder == null) {
            return;
        }
        this.nodeBuilder.setOperation(this.getOperationName());
        this.nodeBuilder.setTimestamp(TimeUtil.toMicros(this.getStart()));
        this.nodeBuilder.setDuration(TimeUnit.NANOSECONDS.toMicros(this.getDuration().toNanos()));
        this.traceContext.getNodeProcessors().forEach(np -> np.process(this.traceContext, this, this.nodeBuilder));
        this.traceContext.endProcessingNode();
        this.nodeBuilder = null;
    }

    private boolean isCompleted() {
        return this.nodeBuilder == null;
    }

    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    protected TraceContext getTraceContext() {
        return this.traceContext;
    }

    @Override
    public Map<String, Object> state() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("HWKAPMTRACEID", this.traceContext.getTraceId());
        ReportingLevel reportingLevelFromTags = ReportingLevel.parse(this.getTags().get(Tags.SAMPLING_PRIORITY.getKey()));
        if (reportingLevelFromTags != null) {
            state.put("HWKAPMLEVEL", (Object)reportingLevelFromTags);
        } else if (this.traceContext.getReportingLevel() != null) {
            state.put("HWKAPMLEVEL", this.traceContext.getReportingLevel().toString());
        }
        if (this.traceContext.getTransaction() != null) {
            state.put("HWKAPMTXN", this.traceContext.getTransaction());
        } else {
            Object transactionFromTags = this.getTags().get("transaction");
            if (transactionFromTags != null) {
                state.put("HWKAPMTXN", transactionFromTags);
            }
        }
        return state;
    }
}

