/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.trace;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.NodeType;

@ApiModel(parent=InteractionNode.class)
public class Component
extends InteractionNode {
    @JsonInclude
    private String componentType;

    public Component() {
        super(NodeType.Component);
    }

    public Component(String uri, String componentType) {
        super(NodeType.Component, uri);
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.componentType == null ? 0 : this.componentType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        return !(this.componentType == null ? other.componentType != null : !this.componentType.equals(other.componentType));
    }

    public String toString() {
        return "Component [componentType=" + this.componentType + ", getIn()=" + this.getIn() + ", getOut()=" + this.getOut() + ", getNodes()=" + this.getNodes() + ", getType()=" + (Object)((Object)this.getType()) + ", getUri()=" + this.getUri() + ", getOperation()=" + this.getOperation() + ", getTimestamp()=" + this.getTimestamp() + ", getDuration()=" + this.getDuration() + ", getProperties()=" + this.getProperties() + ", getCorrelationIds()=" + this.getCorrelationIds() + ", getIssues()=" + this.getIssues() + "]";
    }
}

