/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;

public class Criteria {
    private static final Logger log = Logger.getLogger(Criteria.class.getName());
    private long startTime = 0L;
    private long endTime = 0L;
    private String transaction;
    private Set<PropertyCriteria> properties = new HashSet<PropertyCriteria>();
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();
    private String hostName;
    private long upperBound;
    private long lowerBound;
    private String uri;
    private String operation;
    private long timeout = 10000L;
    private int maxResponseSize = 100000;

    public Criteria() {
    }

    public Criteria(Criteria criteria) {
        this.startTime = criteria.startTime;
        this.endTime = criteria.endTime;
        this.transaction = criteria.transaction;
        this.hostName = criteria.hostName;
        this.upperBound = criteria.upperBound;
        this.lowerBound = criteria.lowerBound;
        this.uri = criteria.uri;
        this.operation = criteria.operation;
        criteria.properties.forEach(pc -> this.properties.add(new PropertyCriteria((PropertyCriteria)pc)));
        criteria.correlationIds.forEach(cid -> this.correlationIds.add(new CorrelationIdentifier((CorrelationIdentifier)cid)));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Criteria setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long calculateStartTime() {
        if (this.startTime == 0L) {
            return this.calculateEndTime() - 3600000L;
        }
        if (this.startTime < 0L) {
            return this.calculateEndTime() + this.startTime;
        }
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Criteria setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public long calculateEndTime() {
        if (this.endTime == 0L) {
            return System.currentTimeMillis();
        }
        if (this.endTime < 0L) {
            return System.currentTimeMillis() - this.endTime;
        }
        return this.endTime;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public Criteria setTransaction(String name) {
        this.transaction = name;
        return this;
    }

    public Set<PropertyCriteria> getProperties() {
        return this.properties;
    }

    public Criteria setProperties(Set<PropertyCriteria> properties) {
        this.properties = properties;
        return this;
    }

    public Criteria addProperty(String name, String value, Operator operator) {
        this.properties.add(new PropertyCriteria(name, value, operator));
        return this;
    }

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public Criteria setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Criteria setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public String getUri() {
        return this.uri;
    }

    public Criteria setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getOperation() {
        return this.operation;
    }

    public Criteria setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public Map<String, String> parameters() {
        StringBuilder buf;
        boolean first;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.getTransaction() != null) {
            ret.put("transaction", this.getTransaction());
        }
        if (this.getStartTime() > 0L) {
            ret.put("startTime", "" + this.getStartTime());
        }
        if (this.getEndTime() > 0L) {
            ret.put("endTime", "" + this.getEndTime());
        }
        if (!this.getProperties().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (PropertyCriteria pc : this.getProperties()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(pc.encoded());
            }
            ret.put("properties", buf.toString());
        }
        if (this.hostName != null) {
            ret.put("hostName", this.hostName);
        }
        if (!this.getCorrelationIds().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (CorrelationIdentifier cid : this.getCorrelationIds()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(cid.getScope().name());
                buf.append('|');
                buf.append(cid.getValue());
            }
            ret.put("correlations", buf.toString());
        }
        if (this.uri != null) {
            ret.put("uri", this.uri);
        }
        if (this.operation != null) {
            ret.put("operation", this.operation);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Criteria parameters [" + ret + "]");
        }
        return ret;
    }

    public boolean transactionWide() {
        return this.properties.isEmpty() && this.correlationIds.isEmpty() && this.hostName == null && this.uri == null && this.operation == null;
    }

    public Criteria deriveTransactionWide() {
        Criteria ret = new Criteria();
        ret.setStartTime(this.startTime);
        ret.setEndTime(this.endTime);
        ret.setProperties(this.getProperties().stream().filter(p -> p.getName().equals("principal")).collect(Collectors.toSet()));
        ret.setTransaction(this.transaction);
        return ret;
    }

    public String toString() {
        return "Criteria [startTime=" + this.startTime + ", endTime=" + this.endTime + ", transaction=" + this.transaction + ", properties=" + this.properties + ", correlationIds=" + this.correlationIds + ", hostName=" + this.hostName + ", upperBound=" + this.upperBound + ", lowerBound=" + this.lowerBound + ", uri=" + this.uri + ", operation=" + this.operation + ", timeout=" + this.timeout + ", maxResponseSize=" + this.maxResponseSize + "]";
    }

    public static class PropertyCriteria {
        private String name;
        private String value;
        private Operator operator = Operator.HAS;

        public PropertyCriteria() {
        }

        public PropertyCriteria(PropertyCriteria pc) {
            this.name = pc.name;
            this.value = pc.value;
            this.operator = pc.operator;
        }

        public PropertyCriteria(String name, String value, Operator operator) {
            this.name = name;
            this.value = value;
            this.setOperator(operator);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Operator operator) {
            if (operator == null) {
                operator = Operator.HAS;
            }
            this.operator = operator;
        }

        public String encoded() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getName());
            buf.append('|');
            buf.append(this.getValue());
            if (this.getOperator() != Operator.HAS) {
                buf.append('|');
                buf.append((Object)this.getOperator());
            }
            return buf.toString();
        }

        public String toString() {
            return "PropertyCriteria [name=" + this.name + ", value=" + this.value + ", operator=" + (Object)((Object)this.operator) + "]";
        }
    }

    public static enum Operator {
        HAS,
        HASNOT,
        EQ,
        NE,
        GT,
        GTE,
        LT,
        LTE;

    }
}

