/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.HelperManager;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.ScriptRepository;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.check.RuleCheckResult;
import org.jboss.byteman.modules.NonModuleSystem;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.exception.TypeWarningException;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;
import org.jboss.byteman.rule.type.TypeHelper;

public class RuleCheck {
    private List<String> ruleTexts = new ArrayList<String>();
    private List<String> ruleFiles = new ArrayList<String>();
    private List<String> packages = new LinkedList<String>();
    private RuleCheckResult result = new RuleCheckResult();
    PrintStream output = null;
    private boolean verbose = false;
    private HelperManager helperManager = new HelperManager(null, new RuleCheckModuleSystem());

    public void setPrintStream(PrintStream printStream) {
        this.output = printStream;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void addRule(String name, String text) {
        this.ruleFiles.add(name);
        this.ruleTexts.add(text);
    }

    public boolean addRuleFile(String file) {
        try {
            int count;
            FileInputStream fis = new FileInputStream(new File(file));
            int max = fis.available();
            byte[] bytes = new byte[max];
            int read = count = fis.read(bytes);
            while (count > 0 && read < max) {
                count = fis.read(bytes, read, max - read);
            }
            if (read < max) {
                this.result.addError("ERROR : Unable to read full contents of file : " + file);
                return false;
            }
            String ruleText = new String(bytes);
            this.ruleTexts.add(ruleText);
            this.ruleFiles.add(file);
        }
        catch (IOException ioe) {
            this.error("ERROR : Unable to open file : " + file, ioe);
            return false;
        }
        return true;
    }

    public void addPackage(String name) {
        this.packages.add(name);
    }

    public void checkRules() {
        ClassLoader loader = this.getClass().getClassLoader();
        ScriptRepository repository = new ScriptRepository(false);
        ArrayList<RuleScript> allScripts = new ArrayList<RuleScript>();
        Iterator<String> textsIter = this.ruleTexts.iterator();
        Iterator<String> filesIter = this.ruleFiles.iterator();
        while (textsIter.hasNext()) {
            String ruleText = textsIter.next();
            String ruleFile = filesIter.next();
            List<RuleScript> ruleScripts = null;
            try {
                ruleScripts = repository.processScripts(ruleText, ruleFile);
                allScripts.addAll(ruleScripts);
            }
            catch (Exception e) {
                this.error("ERROR : Could not process rule file " + ruleFile + " : ", e);
            }
        }
        ArrayList<String> emptyInitialTexts = new ArrayList<String>();
        ArrayList<String> emptyInitialFiles = new ArrayList<String>();
        for (RuleScript script : allScripts) {
            String infoMessage;
            String targetClassName = script.getTargetClass();
            Class<?> targetClass = null;
            try {
                targetClass = loader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (targetClass == null && targetClassName.indexOf(46) < 0) {
                for (int i = 0; i < this.packages.toArray().length; ++i) {
                    String qualifiedName = this.packages.toArray()[i] + "." + targetClassName;
                    try {
                        targetClass = loader.loadClass(qualifiedName);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        this.error("ERROR : Unexpected error looking up " + targetClassName + " in package " + this.packages.toArray()[i], e);
                        return;
                    }
                    if (targetClass != null) break;
                }
            }
            if (targetClass == null) {
                this.error("ERROR : Could not load class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                continue;
            }
            if (script.isInterface() && !targetClass.isInterface()) {
                this.error("ERROR : Found class instead of interface for rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                continue;
            }
            if (!script.isInterface() && targetClass.isInterface()) {
                this.error("ERROR : Found interface instead of class for rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                continue;
            }
            if (!script.isInterface()) {
                byte[] bytes;
                block43: {
                    String resourceName = targetClass.getName().replace(".", "/") + ".class";
                    bytes = null;
                    try {
                        int read;
                        int count;
                        InputStream stream = loader.getResourceAsStream(resourceName);
                        int max = stream.available();
                        bytes = new byte[max];
                        for (read = count = stream.read(bytes); count > 0 && read < max; read += count) {
                            count = stream.read(bytes, read, max - read);
                        }
                        if (read < max) {
                            this.error("ERROR : Could not load bytecode for class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                        }
                        break block43;
                    }
                    catch (Exception e) {
                        this.error("ERROR : Could not load bytecode for class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), e);
                    }
                    continue;
                }
                Transformer transformer = null;
                try {
                    transformer = new Transformer(null, this.helperManager.getModuleSystem(), emptyInitialTexts, emptyInitialFiles, false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.info("Checking rule " + script.getName() + " against class " + targetClass.getName());
                bytes = transformer.transform(script, loader, targetClass.getName(), bytes);
                Transformer.maybeDumpClass(targetClass.getName(), bytes);
            }
            if (script.hasTransform(targetClass)) {
                List<Transform> transforms = script.getTransformed();
                int numTransforms = transforms.size();
                for (Transform transform : transforms) {
                    Throwable throwable = transform.getThrowable();
                    Rule rule = transform.getRule();
                    String methodName = transform.getTriggerMethodName();
                    if (throwable != null) {
                        if (throwable instanceof ParseException) {
                            this.parseError("ERROR : Failed to parse rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), throwable);
                            continue;
                        }
                        if (throwable instanceof TypeWarningException) {
                            this.typeWarning("WARNING : Problem type checking rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), throwable);
                            continue;
                        }
                        if (throwable instanceof TypeException) {
                            this.typeError("ERROR : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), throwable);
                            continue;
                        }
                        this.error("ERROR : Unexpected exception transforming class " + targetClassName + " using  rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), throwable);
                        continue;
                    }
                    infoMessage = "Parsed rule \"" + script.getName() + "\" for class " + transform.getInternalClassName();
                    if (this.verbose) {
                        infoMessage = infoMessage + "# File " + script.getFile() + " line " + script.getLine() + "\n";
                        infoMessage = infoMessage + rule;
                    }
                    this.info(infoMessage);
                    try {
                        rule.typeCheck();
                        rule.compile();
                    }
                    catch (TypeWarningException te) {
                        this.typeWarning("WARNING : Unable to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), te);
                        continue;
                    }
                    catch (TypeException te) {
                        this.typeError("ERROR : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), te);
                        continue;
                    }
                    catch (CompileException ce) {
                        this.typeError("ERROR : Failed to compile rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), ce);
                        continue;
                    }
                    catch (Throwable th) {
                        this.typeError("ERROR : Failed to check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine() + (methodName == null ? "" : " against method " + methodName), th);
                        continue;
                    }
                    if (script.isOverride()) {
                        this.info("Type checked overriding rule \"" + script.getName() + "\" against method in declared class");
                        continue;
                    }
                    this.info("Type checked rule \"" + script.getName() + "\"");
                }
            } else if (targetClass.isInterface() || script.isOverride()) {
                Rule rule;
                try {
                    rule = Rule.create(script, loader, this.helperManager);
                }
                catch (ParseException pe) {
                    this.parseError("ERROR : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), pe);
                    continue;
                }
                catch (TypeWarningException te) {
                    this.typeWarning("WARNING : Unable to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), te);
                    continue;
                }
                catch (TypeException te) {
                    this.typeError("ERROR : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), te);
                    continue;
                }
                catch (Throwable th) {
                    this.error("ERROR : Failed to process rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), th);
                    continue;
                }
                infoMessage = "Parsed rule \"" + script.getName() + "\"";
                if (this.verbose) {
                    infoMessage = infoMessage + "# File " + script.getFile() + " line " + script.getLine();
                    infoMessage = infoMessage + rule;
                }
                this.info(infoMessage);
                this.typeCheckAgainstMethodDeclaration(rule, script, targetClass, loader);
            } else {
                this.warning("WARNING : Unable to transform class " + targetClassName + " using rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            }
            this.info("");
        }
    }

    private void typeCheckAgainstMethodDeclaration(Rule rule, RuleScript script, Class targetClass, ClassLoader loader) {
        String targetMethodName = script.getTargetMethod();
        String targetName = TypeHelper.parseMethodName(targetMethodName);
        String targetDesc = TypeHelper.parseMethodDescriptor(targetMethodName);
        if (targetName == "<clinit>") {
            this.warning("WARNING : Cannot type check <clinit> rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            return;
        }
        if (targetMethodName == "<init>") {
            if (script.isInterface()) {
                this.error("ERROR : Invalid target method <init> for interface rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                return;
            }
            this.error("ERROR : Invalid target method <init> for overriding rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            return;
        }
        Method[] candidates = targetClass.getDeclaredMethods();
        int matchCount = 0;
        for (Method candidate : candidates) {
            String candidateName = candidate.getName();
            String candidateDesc = RuleCheck.makeDescriptor(candidate);
            if (!targetName.equals(candidateName) || !targetDesc.equals("") && !TypeHelper.equalDescriptors(targetDesc, candidateDesc)) continue;
            if (++matchCount > 1) {
                try {
                    rule = Rule.create(script, loader, this.helperManager);
                }
                catch (ParseException e) {
                }
                catch (TypeException e) {
                }
                catch (CompileException e) {
                    // empty catch block
                }
            }
            int access = 0;
            Class<?>[] exceptionClasses = candidate.getExceptionTypes();
            int l = exceptionClasses.length;
            String[] exceptionNames = new String[l];
            for (int i = 0; i < l; ++i) {
                exceptionNames[i] = exceptionClasses[i].getCanonicalName();
            }
            if ((candidate.getModifiers() & 8) != 0) {
                access = 8;
            }
            rule.setTypeInfo(targetClass.getName(), access, candidateName, candidateDesc, exceptionNames);
            int paramErrorCount = this.installParamTypes(rule, targetClass.getName(), access, candidateName, candidateDesc);
            if (paramErrorCount == 0) {
                try {
                    rule.typeCheck();
                    rule.compile();
                }
                catch (TypeWarningException te) {
                    this.typeWarning("WARNING : Unable to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), te);
                    System.out.println(te);
                    System.out.println();
                    return;
                }
                catch (TypeException te) {
                    this.typeError("ERROR : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), te);
                    System.out.println(te);
                    System.out.println();
                    return;
                }
                catch (CompileException ce) {
                    this.typeError("ERROR : Failed to compile rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), ce);
                    System.out.println(ce);
                    System.out.println();
                    return;
                }
                catch (Throwable th) {
                    this.error("ERROR : Failed to process rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine(), th);
                    return;
                }
                if (script.isInterface()) {
                    this.info("Type checked interface rule \"" + script.getName() + "\" against method declaration");
                    continue;
                }
                this.info("Type checked overriding rule \"" + script.getName() + "\" against method declaration");
                continue;
            }
            this.info("Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
        }
    }

    static String makeDescriptor(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> retType = method.getReturnType();
        String desc = "(";
        for (Class<?> paramType : paramTypes) {
            String name = paramType.getCanonicalName();
            desc = desc + TypeHelper.externalizeType(name);
        }
        desc = desc + ")";
        desc = desc + TypeHelper.externalizeType(retType.getCanonicalName());
        return desc;
    }

    static String makeDescriptor(Constructor constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        String desc = "(";
        for (Class<?> paramType : paramTypes) {
            String name = paramType.getCanonicalName();
            desc = desc + TypeHelper.externalizeType(name);
        }
        desc = desc + ")";
        return desc;
    }

    public int installParamTypes(Rule rule, String targetClassName, int access, String candidateName, String candidateDesc) {
        List<String> paramTypes = Type.parseMethodDescriptor(candidateDesc, true);
        int paramCount = paramTypes.size() - 1;
        int errorCount = 0;
        TypeGroup typegroup = rule.getTypeGroup();
        Bindings bindings = rule.getBindings();
        Iterator<Binding> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            if (binding.getType() != Type.UNDEFINED) continue;
            if (binding.isRecipient()) {
                binding.setDescriptor(targetClassName);
                continue;
            }
            if (binding.isParam()) {
                int idx = binding.getIndex();
                if (idx > paramCount) {
                    ++errorCount;
                    this.error("ERROR : Invalid method parameter reference $" + idx + " in rule \"" + rule.getName() + "\"");
                    continue;
                }
                binding.setDescriptor(paramTypes.get(idx - 1));
                continue;
            }
            if (binding.isReturn()) {
                if (rule.getTargetLocation().getLocationType() != LocationType.INVOKE_COMPLETED) {
                    String returnType = paramTypes.get(paramCount);
                    if ("void".equals(returnType)) {
                        ++errorCount;
                        this.error("ERROR : Invalid return value reference $! in rule \"" + rule.getName() + "\"");
                        continue;
                    }
                    binding.setDescriptor(returnType);
                    continue;
                }
                this.warning("WARNING : Cannot infer type for $! in AFTER INVOKE rule \"" + rule.getName() + "\"");
                binding.setDescriptor("void");
                continue;
            }
            if (!binding.isLocalVar()) continue;
            this.warning("WARNING : Cannot typecheck local variable " + binding.getName() + " in rule \"" + rule.getName() + "\"");
            binding.setDescriptor("void");
        }
        return errorCount;
    }

    private void error(String message) {
        this.error(message, null);
    }

    private void error(String message, Throwable th) {
        if (th != null) {
            message = message + "\n";
            message = message + th;
        }
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addError(message);
    }

    private void parseError(String message, Throwable th) {
        if (th != null) {
            message = message + "\n";
            message = message + th;
        }
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addParseError(message);
    }

    private void typeError(String message, Throwable th) {
        if (th != null) {
            message = message + "\n";
            message = message + th;
        }
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addTypeError(message);
    }

    private void typeWarning(String message, Throwable th) {
        if (th != null) {
            message = message + "\n";
            message = message + th;
        }
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addTypeWarning(message);
    }

    private void warning(String message) {
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addWarning(message);
    }

    private void info(String message) {
        if (this.output != null) {
            this.output.println(message);
        }
        this.result.addInfo(message);
    }

    public RuleCheckResult getResult() {
        return this.result;
    }

    class RuleCheckModuleSystem
    extends NonModuleSystem {
        RuleCheckModuleSystem() {
        }

        @Override
        protected void reportUnexpectedImports(String[] imports) {
            RuleCheck.this.warning("WARNING : Rule checking does not support IMPORT. Additional classpath entries may be required");
        }
    }
}

