/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.StaticExpression;
import org.jboss.byteman.rule.expression.Variable;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class FieldExpression
extends AssignableExpression {
    private Expression owner;
    private String[] pathList;
    private String fieldName;
    private Type ownerType;
    private Field field;
    private AssignableExpression indirectStatic;
    private boolean isArrayLength;
    private boolean isClassAccess;
    private boolean isPublicField;
    private int fieldIndex;

    public FieldExpression(Rule rule, Type type, ParseNode fieldTree, String fieldName, Expression owner, String[] pathList) {
        super(rule, type, fieldTree);
        this.fieldName = fieldName;
        this.owner = owner;
        this.pathList = pathList;
        this.ownerType = null;
        this.indirectStatic = null;
        this.fieldIndex = -1;
        this.isArrayLength = false;
    }

    @Override
    public void bind() throws TypeException {
        if (this.owner != null) {
            this.owner.bind();
        } else {
            String leading = this.pathList[0];
            Binding binding = this.getBindings().lookup(leading);
            if (binding != null) {
                int l = this.pathList.length;
                AssignableExpression owner = new Variable(this.rule, binding.getType(), this.token, binding.getName());
                for (int idx = 1; idx < l; ++idx) {
                    owner = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx], owner, null);
                }
                this.owner = owner;
                this.pathList = null;
                this.owner.bind();
            }
        }
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.checkIndirectStatic();
        if (this.indirectStatic != null) {
            this.type = Type.dereference(this.indirectStatic.typeCheck(expected));
        } else {
            this.typeCheckAny();
            if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
                throw new TypeException("FieldExpresssion.typeCheck : invalid expected type " + expected.getName() + this.getPos());
            }
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.checkIndirectStatic();
        if (this.indirectStatic != null) {
            this.type = Type.dereference(this.indirectStatic.typeCheckAssign(expected));
            return this.type;
        }
        this.typeCheckAny();
        if (this.isArrayLength) {
            throw new TypeException("FieldExpresssion.typeCheck : invalid attempt to update array length " + this.owner + this.getPos());
        }
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("FieldExpresssion.typeCheck : invalid value type " + expected.getName() + "for assignment" + this.getPos());
        }
        return this.type;
    }

    private void checkIndirectStatic() throws TypeException {
        if (this.owner == null && this.pathList != null) {
            TypeGroup typeGroup = this.getTypeGroup();
            Type rootType = typeGroup.match(this.pathList);
            if (rootType == null) {
                throw new TypeException("FieldExpression.typeCheck : invalid path " + this.getPath(this.pathList.length) + " to static field " + this.fieldName + this.getPos());
            }
            String rootTypeName = rootType.getName();
            int idx = this.getPathCount(rootTypeName);
            if (idx < this.pathList.length) {
                String fieldName = this.pathList[idx++];
                AssignableExpression owner = new StaticExpression(this.rule, Type.UNDEFINED, this.token, fieldName, rootTypeName);
                while (idx < this.pathList.length) {
                    owner = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx++], owner, null);
                }
                this.owner = owner;
                this.owner.bind();
            } else {
                this.indirectStatic = new StaticExpression(this.rule, Type.UNDEFINED, this.token, this.fieldName, rootTypeName);
                this.indirectStatic.bind();
            }
            this.pathList = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void typeCheckAny() throws TypeException {
        this.ownerType = Type.dereference(this.owner.typeCheck(Type.UNDEFINED));
        if (this.ownerType.isUndefined()) {
            throw new TypeException("FieldExpresssion.typeCheck : unbound owner type for field " + this.fieldName + this.getPos());
        }
        Class ownerClazz = this.ownerType.getTargetClass();
        Class<?> valueClass = null;
        if (this.ownerType.isArray()) {
            if (!this.fieldName.equals("length")) throw new TypeException("FieldExpresssion.typeCheck : array type " + this.ownerType.getName() + " does not accept field reference " + this.fieldName + this.getPos());
            this.isArrayLength = true;
            this.type = Type.I;
            return;
        }
        try {
            this.field = this.lookupField(ownerClazz);
        }
        catch (NoSuchFieldException e) {
            throw new TypeException("FieldExpresssion.typeCheck : invalid field reference " + this.ownerType.getName() + " ." + this.fieldName + this.getPos());
        }
        if ((this.field.getModifiers() & 8) != 0) {
            throw new TypeException("FieldExpresssion.typeCheck : field is static " + this.ownerType.getName() + " ." + this.fieldName + this.getPos());
        }
        valueClass = this.field.getType();
        this.type = this.getTypeGroup().ensureType(valueClass);
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.indirectStatic != null) {
            return this.indirectStatic.interpret(helper);
        }
        if (this.isArrayLength) {
            Object value = this.owner.interpret(helper);
            if (value == null) {
                throw new ExecuteException("FieldExpression.interpret : attempted array length indirection through null value " + this.owner + this.getPos());
            }
            try {
                return Array.getLength(value);
            }
            catch (Exception e) {
                throw new ExecuteException("FieldExpression.interpret : exception accessing array length " + this.owner + this.getPos(), e);
            }
        }
        try {
            Object value = this.owner.interpret(helper);
            if (value == null) {
                throw new ExecuteException("FieldExpression.interpret : attempted field indirection through null value " + this.owner + this.getPos());
            }
            return this.field.get(value);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("FieldExpression.interpret : error accessing field " + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("FieldExpression.interpret : unexpected exception accessing field " + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int expected;
        compileContext.notifySourceLine(this.line);
        int currentStack = compileContext.getStackCount();
        int n = expected = this.type.getNBytes() > 4 ? 2 : 1;
        if (this.indirectStatic != null) {
            this.indirectStatic.compile(mv, compileContext);
        } else if (this.isArrayLength) {
            this.owner.compile(mv, compileContext);
            mv.visitInsn(190);
            compileContext.addStackCount(expected - 1);
        } else if (this.isPublicField) {
            String ownerType = Type.internalName(this.field.getDeclaringClass());
            String fieldName = this.field.getName();
            String fieldType = Type.internalName(this.field.getType(), true);
            this.owner.compile(mv, compileContext);
            mv.visitFieldInsn(180, ownerType, fieldName, fieldType);
            compileContext.addStackCount(expected - 1);
        } else {
            mv.visitVarInsn(25, 0);
            compileContext.addStackCount(1);
            this.owner.compile(mv, compileContext);
            mv.visitLdcInsn(this.fieldIndex);
            compileContext.addStackCount(1);
            mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            compileContext.addStackCount(-2);
            this.compileTypeConversion(Type.OBJECT, this.type, mv, compileContext);
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("FieldExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    public String getPath(int len) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pathList[0]);
        for (int i = 1; i < len; ++i) {
            buffer.append(".");
            buffer.append(this.pathList[i]);
        }
        return buffer.toString();
    }

    public int getPathCount(String name) {
        if (name.startsWith(this.pathList[0])) {
            int idx;
            int charMax = name.length();
            int charCount = 0;
            int dotExtra = 0;
            for (idx = 0; idx < this.pathList.length && (charCount += dotExtra + this.pathList[idx].length()) <= charMax; ++idx) {
            }
            return idx;
        }
        return 1;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.owner != null) {
            this.owner.writeTo(stringWriter);
        } else {
            String sepr = "";
            for (String field : this.pathList) {
                stringWriter.write(sepr);
                stringWriter.write(field);
                sepr = ".";
            }
        }
        stringWriter.write(".");
        stringWriter.write(this.fieldName);
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        if (this.indirectStatic != null) {
            return this.indirectStatic.interpretAssign(helperAdapter, value);
        }
        try {
            Object ownerInstance = this.owner.interpret(helperAdapter);
            if (ownerInstance == null) {
                throw new ExecuteException("FieldExpression.interpret : attempted field indirection through null value " + this.owner + this.getPos());
            }
            this.field.set(ownerInstance, value);
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("FieldExpression.interpretAssign : error accessing field " + this.fieldName + this.getPos(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("FieldExpression.interpretAssign : invalid value assigning field " + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("FieldExpression.interpretAssign : unexpected exception accessing field " + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        if (this.indirectStatic != null) {
            this.indirectStatic.compileAssign(mv, compileContext);
        } else {
            int size;
            compileContext.notifySourceLine(this.line);
            int currentStack = compileContext.getStackCount();
            int n = size = this.type.getNBytes() > 4 ? 2 : 1;
            if (size == 1) {
                mv.visitInsn(89);
            } else {
                mv.visitInsn(92);
            }
            compileContext.addStackCount(size);
            this.owner.compile(mv, compileContext);
            if (size == 1) {
                mv.visitInsn(95);
            } else {
                mv.visitInsn(91);
                compileContext.addStackCount(1);
                mv.visitInsn(87);
                compileContext.addStackCount(-1);
            }
            if (this.isPublicField) {
                String ownerType = Type.internalName(this.field.getDeclaringClass());
                String fieldName = this.field.getName();
                String fieldType = Type.internalName(this.field.getType(), true);
                mv.visitFieldInsn(181, ownerType, fieldName, fieldType);
                compileContext.addStackCount(-(1 + size));
            } else {
                if (this.type.isPrimitive()) {
                    this.compileBox(Type.boxType(this.type), mv, compileContext);
                }
                mv.visitVarInsn(25, 0);
                mv.visitInsn(91);
                compileContext.addStackCount(2);
                mv.visitInsn(87);
                mv.visitLdcInsn(this.fieldIndex);
                mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
                compileContext.addStackCount(-4);
            }
            if (compileContext.getStackCount() != currentStack) {
                throw new CompileException("FieldExpression.compileAssign : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
            }
        }
    }

    private Field lookupField(Class<?> ownerClazz) throws NoSuchFieldException {
        try {
            Field field = ownerClazz.getField(this.fieldName);
            if (Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                this.isPublicField = true;
                return field;
            }
            this.isPublicField = false;
            field.setAccessible(true);
            this.fieldIndex = this.rule.addAccessibleField(field);
            return field;
        }
        catch (NoSuchFieldException nsfe) {
            for (Class<?> nextClass = ownerClazz; nextClass != null; nextClass = nextClass.getSuperclass()) {
                try {
                    this.field = nextClass.getDeclaredField(this.fieldName);
                    this.isPublicField = false;
                    this.field.setAccessible(true);
                    this.fieldIndex = this.rule.addAccessibleField(this.field);
                    return this.field;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            throw nsfe;
        }
    }
}

