/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.type.Type;

public abstract class OperExpression
extends Expression {
    protected int oper;
    public static final int UNARY = 4096;
    public static final int BINARY = 8192;
    public static final int TERNARY = 16384;
    public static final int NOT = 4112;
    public static final int TWIDDLE = 4128;
    public static final int OR = 8256;
    public static final int AND = 8257;
    public static final int EQ = 8320;
    public static final int NE = 8321;
    public static final int GT = 8322;
    public static final int LT = 8323;
    public static final int GE = 8324;
    public static final int LE = 8325;
    public static final int BOR = 8448;
    public static final int BAND = 8449;
    public static final int BXOR = 8450;
    public static final int URSH = 8451;
    public static final int RSH = 8452;
    public static final int LSH = 8453;
    public static final int UMINUS = 4608;
    public static final int MUL = 8705;
    public static final int DIV = 8706;
    public static final int PLUS = 8707;
    public static final int MINUS = 8708;
    public static final int MOD = 8709;
    public static final int ASSIGN = 9217;
    public static final int COND = 18432;
    private static final int[] operands = new int[]{4112, 4128, 8256, 8257, 8320, 8321, 8322, 8323, 8324, 8325, 8448, 8449, 8450, 8451, 8452, 8453, 4608, 8705, 8706, 8707, 8708, 8709, 9217, 18432};
    private static final int[] parserOperands = new int[]{45, 48, 46, 30, 36, 44, 38, 40, 37, 39, 32, 31, 33, 52, 51, 50, 49, 43, 34, 47, 41, 42, 1, 17};
    private static final String[] operandNames = new String[]{"!", "~", "||", "&&", "==", "!=", ">", "<", ">=", "<=", "|", "&", "^", ">>>", ">>", "<<", "-", "*", "/", "+", "-", "%", "=", "? :"};

    OperExpression(Rule rule, int oper, Type type, ParseNode token) {
        super(rule, type, token);
        this.oper = oper;
    }

    public abstract Expression getOperand(int var1);

    @Override
    public void writeTo(StringWriter stringWriter) {
        if ((this.oper & 0x1000) != 0) {
            stringWriter.write(this.getOperandString());
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(")");
        } else if ((this.oper & 0x2000) != 0) {
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(" ");
            stringWriter.write(this.getOperandString());
            stringWriter.write(" ");
            this.getOperand(1).writeTo(stringWriter);
            stringWriter.write(")");
        } else if (this.oper == 18432) {
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(" ? ");
            this.getOperand(1).writeTo(stringWriter);
            stringWriter.write(" : ");
            this.getOperand(2).writeTo(stringWriter);
            stringWriter.write(")");
        } else {
            stringWriter.write("*** error unknown operator *** " + this.oper);
        }
    }

    private String getOperandString() {
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] != this.oper) continue;
            return operandNames[i];
        }
        return "*** error unknown operator ***";
    }

    public static int convertOper(int parserOper) {
        for (int i = 0; i < parserOperands.length; ++i) {
            if (parserOperands[i] != parserOper) continue;
            return operands[i];
        }
        return -1;
    }
}

