/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.global;

import io.opentracing.NoopTracerFactory;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GlobalTracer
implements Tracer {
    private static final Logger LOGGER = Logger.getLogger(GlobalTracer.class.getName());
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private final AtomicReference<Tracer> globalTracer = new AtomicReference();

    private GlobalTracer() {
    }

    private Tracer lazyTracer() {
        Tracer tracer = this.globalTracer.get();
        if (tracer == null) {
            Tracer resolved = GlobalTracer.loadSingleSpiImplementation();
            while (tracer == null && resolved != null) {
                this.globalTracer.compareAndSet(null, resolved);
                tracer = this.globalTracer.get();
            }
            LOGGER.log(Level.INFO, "Using GlobalTracer: {0}.", tracer);
        }
        return tracer;
    }

    public static Tracer get() {
        return INSTANCE;
    }

    public static Tracer register(Tracer tracer) {
        if (tracer instanceof GlobalTracer) {
            LOGGER.log(Level.FINE, "Attempted to register the GlobalTracer as delegate of itself.");
            return GlobalTracer.INSTANCE.globalTracer.get();
        }
        Tracer previous = GlobalTracer.INSTANCE.globalTracer.getAndSet(tracer);
        LOGGER.log(Level.INFO, "Registered GlobalTracer {0} (previously {1}).", new Object[]{tracer, previous});
        return previous;
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return this.lazyTracer().buildSpan(operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.lazyTracer().inject(spanContext, format, carrier);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.lazyTracer().extract(format, carrier);
    }

    private static Tracer loadSingleSpiImplementation() {
        Iterator<Tracer> spiImplementations = ServiceLoader.load(Tracer.class, Tracer.class.getClassLoader()).iterator();
        if (spiImplementations.hasNext()) {
            Tracer foundImplementation = spiImplementations.next();
            if (!spiImplementations.hasNext()) {
                return foundImplementation;
            }
            LOGGER.log(Level.WARNING, "More than one Tracer service found. Falling back to NoopTracer implementation.");
        }
        return NoopTracerFactory.create();
    }
}

