/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.global.GlobalTracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class OpenTracingManager
extends Helper {
    private static final Logger log;
    private Tracer tracer = GlobalTracer.get();
    private static final ThreadLocal<TraceState> traceState;
    private static final Map<String, TraceState> suspendedState;
    private static final ReentrantLock suspendedStateLock;
    private static long expiryInterval;
    protected static Set<String> fileExtensionWhitelist;

    public OpenTracingManager(Rule rule) {
        super(rule);
    }

    public Format<TextMap> textMapFormat() {
        return Format.Builtin.TEXT_MAP;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void startSpanWithParent(Tracer.SpanBuilder spanBuilder, Span parent) {
        this.startSpanWithParent(spanBuilder, parent, null);
    }

    public void startSpanWithParent(Tracer.SpanBuilder spanBuilder, Span parent, String id) {
        if (parent != null) {
            spanBuilder.asChildOf(parent.context());
        }
        this.doStartSpan(spanBuilder, id);
    }

    public void startSpanWithContext(Tracer.SpanBuilder spanBuilder, SpanContext context) {
        this.startSpanWithContext(spanBuilder, context, null);
    }

    public void startSpanWithContext(Tracer.SpanBuilder spanBuilder, SpanContext context, String id) {
        if (context != null) {
            spanBuilder.asChildOf(context);
        }
        this.doStartSpan(spanBuilder, id);
    }

    public void startSpan(Tracer.SpanBuilder spanBuilder) {
        this.doStartSpanWithParent(spanBuilder, null);
    }

    public void startSpan(Tracer.SpanBuilder spanBuilder, String id) {
        this.doStartSpanWithParent(spanBuilder, id);
    }

    protected void doStartSpanWithParent(Tracer.SpanBuilder spanBuilder, String id) {
        Span parentSpan = this.getSpan();
        if (parentSpan != null) {
            spanBuilder.asChildOf(parentSpan);
        }
        this.doStartSpan(spanBuilder, id);
    }

    protected void doStartSpan(Tracer.SpanBuilder spanBuilder, String id) {
        TraceState ts = traceState.get();
        if (ts == null) {
            ts = new TraceState();
            traceState.set(ts);
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Create trace state = " + ts);
            }
        }
        Span span = spanBuilder.start();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Start span = " + span + " id = " + id + " trace state = " + ts);
        }
        ts.pushSpan(span, id);
    }

    public void finishSpan() {
        TraceState ts = traceState.get();
        if (ts != null) {
            Span span = ts.popSpan();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Finish span = " + span + " trace state = " + ts);
            }
            span.finish();
            if (ts.isFinished()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Remove trace state = " + ts);
                }
                traceState.remove();
            }
        } else if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Finish span requested but no trace state");
        }
    }

    public boolean hasSpan() {
        return this.getSpan() != null;
    }

    public boolean hasSpanWithId(String id) {
        TraceState ts = traceState.get();
        if (id != null && ts != null) {
            boolean spanFound;
            boolean bl = spanFound = ts.getSpanForId(id) != null;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Has span with id = " + id + "? " + spanFound);
            }
            return spanFound;
        }
        return false;
    }

    public boolean isCurrentSpan(String id) {
        TraceState ts = traceState.get();
        if (id != null && ts != null) {
            boolean spanFound = ts.peekId().equals(id);
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Is current span id = " + id + "? " + spanFound);
            }
            return spanFound;
        }
        return false;
    }

    public Span getSpan() {
        TraceState ts = traceState.get();
        if (ts != null) {
            Span span = ts.peekSpan();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Get span = " + span + " trace state = " + ts);
            }
            return span;
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get span requested, but no trace state");
        }
        return null;
    }

    public void suspend(String id) {
        TraceState ts = traceState.get();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Suspend trace state = " + ts + " id = " + id);
        }
        if (ts != null) {
            OpenTracingManager.setExpire(ts);
            try {
                suspendedStateLock.lock();
                if (suspendedState.containsKey(id) && log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("WARNING: Overwriting previous suspended trace state = " + suspendedState.get(id) + " id = " + id);
                }
                suspendedState.put(id, ts);
                traceState.remove();
            }
            finally {
                suspendedStateLock.unlock();
            }
        }
    }

    public void resume(String id) {
        try {
            suspendedStateLock.lock();
            TraceState ts = suspendedState.get(id);
            if (ts != null) {
                OpenTracingManager.clearExpire(ts);
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Resume trace state = " + ts + " id = " + id);
                }
                if (traceState.get() != null && log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("WARNING: Overwriting previous trace state = " + traceState.get());
                }
                traceState.set(ts);
                suspendedState.remove(id);
            }
        }
        finally {
            suspendedStateLock.unlock();
        }
    }

    private static void setExpire(TraceState ts) {
        ts.setExpire(System.currentTimeMillis() + expiryInterval);
    }

    private static void clearExpire(TraceState ts) {
        ts.setExpire(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        try {
            suspendedStateLock.lock();
            long timestamp = System.currentTimeMillis();
            Iterator<Map.Entry<String, TraceState>> iter = suspendedState.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, TraceState> entry = iter.next();
                TraceState ts = entry.getValue();
                if (ts.getExpire() <= 0L || ts.getExpire() >= timestamp) continue;
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Expired trace state = " + ts + " id = " + entry.getKey());
                }
                iter.remove();
            }
        }
        finally {
            suspendedStateLock.unlock();
        }
    }

    public static void reset() {
        traceState.remove();
        suspendedState.clear();
    }

    public boolean includePath(String path) {
        String extension;
        int slashPos;
        if (path.startsWith("/hawkular/apm")) {
            return false;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos <= (slashPos = path.lastIndexOf(47))) {
            return true;
        }
        if (!fileExtensionWhitelist.isEmpty() && fileExtensionWhitelist.contains(extension = path.substring(dotPos + 1))) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Path " + path + " not skipped, because of whitelist");
            }
            return true;
        }
        if (log.isLoggable(Logger.Level.FINER)) {
            log.finer("Path " + path + " skipped");
        }
        return false;
    }

    public String getVariableAsString(String name) {
        TraceState ts = traceState.get();
        if (ts != null) {
            Object variable = ts.getVariables().get(name);
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Get variable '" + name + "' = " + variable);
            }
            return variable == null ? null : variable.toString();
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get variable '" + name + "' requested, but no trace state");
        }
        return null;
    }

    public void setVariable(String name, Object value) {
        TraceState ts = traceState.get();
        if (ts != null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set variable '" + name + "' value = " + value);
            }
            ts.getVariables().put(name, value);
        } else if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Set variable '" + name + "' value = " + value + "' requested, but no trace state");
        }
    }

    public boolean isInstanceOf(Object obj, Class<?> clz) {
        if (obj == null || clz == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("isInstanceOf error: obj=" + obj + " clz=" + clz);
            }
            return false;
        }
        return clz.isInstance(obj);
    }

    public String sanitizePaths(String baseUri, String resourcePath) {
        if (baseUri.endsWith("/") && resourcePath.startsWith("/")) {
            return baseUri.substring(0, baseUri.length() - 1) + resourcePath;
        }
        if (!baseUri.endsWith("/") && !resourcePath.startsWith("/")) {
            return baseUri + "/" + resourcePath;
        }
        return baseUri + resourcePath;
    }

    static {
        String time;
        log = Logger.getLogger(OpenTracingManager.class.getName());
        traceState = new ThreadLocal();
        suspendedState = new HashMap<String, TraceState>();
        suspendedStateLock = new ReentrantLock();
        expiryInterval = 60000L;
        fileExtensionWhitelist = new HashSet<String>();
        String whitelist = PropertyUtil.getProperty("HAWKULAR_APM_AGENT_FILE_EXTENSION_WHITELIST", "jsp");
        if (whitelist != null) {
            for (String item : whitelist.split(",")) {
                fileExtensionWhitelist.add(item);
                if (!log.isLoggable(Logger.Level.FINE)) continue;
                log.fine("Added file extension whitelist item: " + item);
            }
        }
        if ((time = PropertyUtil.getProperty("HAWKULAR_APM_AGENT_STATE_EXPIRY_INTERVAL")) != null) {
            expiryInterval = Long.parseLong(time);
        }
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                OpenTracingManager.cleanup();
            }
        }, expiryInterval, expiryInterval, TimeUnit.MILLISECONDS);
    }

    public static class TraceState {
        private Deque<Span> spanStack = new ArrayDeque<Span>();
        private Deque<String> idStack = new ArrayDeque<String>();
        private Map<String, Object> variables = new HashMap<String, Object>();
        private Map<String, Span> identifiedSpans = new HashMap<String, Span>();
        private long expire;

        public void pushSpan(Span span, String id) {
            this.spanStack.push(span);
            this.idStack.push(id == null ? "" : id);
            if (id != null) {
                this.identifiedSpans.put(id, span);
            }
        }

        public Span popSpan() {
            this.idStack.pop();
            return this.spanStack.pop();
        }

        public Span peekSpan() {
            if (this.spanStack.isEmpty()) {
                return null;
            }
            return this.spanStack.peek();
        }

        public String peekId() {
            if (this.idStack.isEmpty()) {
                return null;
            }
            return this.idStack.peek();
        }

        public Span getSpanForId(String id) {
            return this.identifiedSpans.get(id);
        }

        public boolean isFinished() {
            return this.spanStack.isEmpty();
        }

        public void setExpire(long timestamp) {
            this.expire = timestamp;
        }

        public long getExpire() {
            return this.expire;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

