/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing.propagation;

import io.opentracing.propagation.TextMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;

public final class JMSMessageInjectAdapter
implements TextMap {
    private static final Logger log = Logger.getLogger(JMSMessageInjectAdapter.class.getName());
    private final Object message;
    private static Method setStringProperty;

    public JMSMessageInjectAdapter(Object message) {
        this.message = message;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("JMSMessageInjectAdapter should only be used with Tracer.inject()");
    }

    @Override
    public void put(String key, String value) {
        try {
            if (setStringProperty == null) {
                setStringProperty = this.message.getClass().getMethod("setStringProperty", String.class, String.class);
            }
            setStringProperty.invoke(this.message, key, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException t) {
            log.log(Logger.Level.WARNING, "Failed to set header '" + key + "'", t);
        }
    }
}

