/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;

public class CommunicationSeverityAnalyser {
    private static final int MAX_SEVERITY = 5;

    public void evaluateCommunicationSummarySeverity(Collection<CommunicationSummaryStatistics> nodes) {
        long max = 0L;
        HashMap<String, CommunicationSummaryStatistics> nodeMap = new HashMap<String, CommunicationSummaryStatistics>();
        for (CommunicationSummaryStatistics css : nodes) {
            if (css.getAverageDuration() > max) {
                max = css.getAverageDuration();
            }
            nodeMap.put(css.getId(), css);
        }
        for (CommunicationSummaryStatistics css : nodes) {
            CommunicationSeverityAnalyser.deriveSeverity(css, max, nodeMap);
        }
    }

    protected static void deriveSeverity(CommunicationSummaryStatistics css, long max, Map<String, CommunicationSummaryStatistics> nodeMap) {
        max = CommunicationSeverityAnalyser.findParentsMaxAvgDuration(css, max, nodeMap);
        int relative = (int)((double)css.getAverageDuration() * 10.0 / (double)max);
        if (relative >= 10) {
            css.setSeverity(5);
        } else if (relative <= 1) {
            css.setSeverity(0);
        } else {
            css.setSeverity((int)((double)(--relative) * 0.5) + 1);
            if (css.getSeverity() > 5) {
                css.setSeverity(5);
            }
        }
    }

    protected static long findParentsMaxAvgDuration(CommunicationSummaryStatistics css, long max, Map<String, CommunicationSummaryStatistics> nodeMap) {
        long parentMax = max;
        ArrayList<CommunicationSummaryStatistics> parents = new ArrayList<CommunicationSummaryStatistics>();
        for (CommunicationSummaryStatistics parent : nodeMap.values()) {
            if (parent.getId().equals(css.getId())) continue;
            for (String id : parent.getOutbound().keySet()) {
                if (!id.equals(css.getId())) continue;
                parents.add(parent);
            }
        }
        if (!parents.isEmpty()) {
            if (parents.size() == 1) {
                parentMax = ((CommunicationSummaryStatistics)parents.get(0)).getAverageDuration();
            } else {
                for (CommunicationSummaryStatistics parent : parents) {
                    parentMax += parent.getAverageDuration();
                }
                parentMax /= (long)parents.size();
            }
        }
        return parentMax;
    }
}

