/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import io.opentracing.impl.APMSpan;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.config.ReportingLevel;
import org.hawkular.apm.api.model.events.EndpointRef;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.client.api.recorder.TraceRecorder;
import org.hawkular.apm.client.api.sampler.ContextSampler;
import org.hawkular.apm.client.opentracing.DefaultNodeProcessor;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.NodeProcessor;
import org.hawkular.apm.client.opentracing.TagUtil;

public class TraceContext {
    private static final Logger log = Logger.getLogger(TraceContext.class.getName());
    private Trace trace;
    private APMSpan topSpan;
    private NodeBuilder rootNode;
    private String transaction;
    private ReportingLevel reportingLevel;
    private AtomicInteger nodeCount = new AtomicInteger(0);
    private TraceRecorder recorder;
    private ContextSampler sampler;
    private static List<NodeProcessor> nodeProcessors = new ArrayList<NodeProcessor>();

    public TraceContext(APMSpan topSpan, NodeBuilder rootNode, TraceRecorder recorder, ContextSampler sampler) {
        this.topSpan = topSpan;
        this.rootNode = rootNode;
        this.recorder = recorder;
        this.sampler = sampler;
        this.trace = new Trace();
        this.trace.setFragmentId(UUID.randomUUID().toString());
        this.trace.setTraceId(this.trace.getFragmentId());
        this.trace.setHostName(PropertyUtil.getHostName());
        this.trace.setHostAddress(PropertyUtil.getHostAddress());
        rootNode.setNodePath(String.format("%s:0", this.trace.getFragmentId()));
    }

    public void startProcessingNode() {
        this.nodeCount.incrementAndGet();
    }

    public void endProcessingNode() {
        if (this.nodeCount.decrementAndGet() == 0 && this.recorder != null) {
            boolean sampled;
            Node node = this.rootNode.build();
            this.trace.setTimestamp(node.getTimestamp());
            this.trace.setTransaction(this.getTransaction());
            this.trace.getNodes().add(node);
            if (TraceContext.checkForSamplingProperties(node)) {
                this.reportingLevel = ReportingLevel.All;
            }
            if ((sampled = this.sampler.isSampled(this.trace, this.reportingLevel)) && this.reportingLevel == null) {
                this.reportingLevel = ReportingLevel.All;
            }
            if (sampled) {
                this.recorder.record(this.trace);
            }
        }
    }

    public String getTraceId() {
        return this.trace.getTraceId();
    }

    public void setTraceId(String traceId) {
        this.trace.setTraceId(traceId);
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public ReportingLevel getReportingLevel() {
        return this.reportingLevel;
    }

    public void setReportingLevel(ReportingLevel reportingLevel) {
        this.reportingLevel = reportingLevel;
    }

    public List<NodeProcessor> getNodeProcessors() {
        return nodeProcessors;
    }

    public APMSpan getTopSpan() {
        return this.topSpan;
    }

    public EndpointRef getSourceEndpoint() {
        return new EndpointRef(TagUtil.getUriPath(this.topSpan.getTags()), this.topSpan.getOperationName(), false);
    }

    public void initTraceState(Map<String, Object> state) {
        Object traceId = state.get("HWKAPMTRACEID");
        Object transaction = state.get("HWKAPMTXN");
        Object level = state.get("HWKAPMLEVEL");
        if (traceId != null) {
            this.setTraceId(traceId.toString());
        } else {
            log.severe("Trace id has not been propagated");
        }
        if (transaction != null) {
            this.setTransaction(transaction.toString());
        }
        if (level != null) {
            this.setReportingLevel(ReportingLevel.valueOf(level.toString()));
        }
    }

    private static boolean checkForSamplingProperties(Node node) {
        Set<Property> samplingProperties = node instanceof ContainerNode ? ((ContainerNode)node).getPropertiesIncludingDescendants(Tags.SAMPLING_PRIORITY.getKey()) : node.getProperties(Tags.SAMPLING_PRIORITY.getKey());
        for (Property prop : samplingProperties) {
            int priority = 0;
            try {
                priority = Integer.parseInt(prop.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (priority <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        nodeProcessors.add(new DefaultNodeProcessor());
    }
}

