/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.analytics.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.analytics.Cardinality;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;
import org.hawkular.apm.api.model.analytics.EndpointInfo;
import org.hawkular.apm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.apm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.Percentiles;
import org.hawkular.apm.api.model.analytics.PropertyInfo;
import org.hawkular.apm.api.model.analytics.TimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.TransactionInfo;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.services.AnalyticsService;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.client.api.rest.AbstractRESTClient;

public class AnalyticsServiceRESTClient
extends AbstractRESTClient
implements AnalyticsService {
    private static final Logger log = Logger.getLogger((String)AnalyticsServiceRESTClient.class.getName());
    private static final TypeReference<List<EndpointInfo>> URIINFO_LIST = new TypeReference<List<EndpointInfo>>(){};
    private static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
    private static final TypeReference<Long> LONG = new TypeReference<Long>(){};
    private static final TypeReference<List<TimeseriesStatistics>> TIMESERIES_STATISTICS_LIST = new TypeReference<List<TimeseriesStatistics>>(){};
    private static final TypeReference<List<NodeTimeseriesStatistics>> NODE_TIMESERIES_STATISTICS_LIST = new TypeReference<List<NodeTimeseriesStatistics>>(){};
    private static final TypeReference<List<NodeSummaryStatistics>> NODE_SUMMARY_STATISTICS_LIST = new TypeReference<List<NodeSummaryStatistics>>(){};
    private static final TypeReference<List<CommunicationSummaryStatistics>> COMMS_SUMMARY_STATISTICS_LIST = new TypeReference<List<CommunicationSummaryStatistics>>(){};
    private static final TypeReference<List<Cardinality>> CARDINALITY_LIST = new TypeReference<List<Cardinality>>(){};
    private static final TypeReference<List<TransactionInfo>> TRANSACTION_INFO_LIST = new TypeReference<List<TransactionInfo>>(){};
    private static final TypeReference<List<PropertyInfo>> PROPERTY_INFO_LIST = new TypeReference<List<PropertyInfo>>(){};
    private static final TypeReference<List<CompletionTime>> COMPLETION_TIME_LIST = new TypeReference<List<CompletionTime>>(){};
    private static final TypeReference<Percentiles> PERCENTILES_TYPE_REFERENCE = new TypeReference<Percentiles>(){};

    public AnalyticsServiceRESTClient() {
        super("HAWKULAR_APM_URI_SERVICES");
    }

    public AnalyticsServiceRESTClient(String username, String password, String url) {
        super(username, password, url);
    }

    public List<EndpointInfo> getUnboundEndpoints(String tenantId, long startTime, long endTime, boolean compress) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get unbound endpoints: tenantId=[" + tenantId + "] startTime=" + startTime + " endTime=" + endTime + " compress=" + compress);
        }
        String path = "analytics/unboundendpoints?startTime=%d&endTime=%d&compress=%b";
        return (List)this.getResultsForUrl(tenantId, URIINFO_LIST, path, new Object[]{startTime, endTime, compress});
    }

    public List<EndpointInfo> getBoundEndpoints(String tenantId, String transaction, long startTime, long endTime) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get bound endpoints: tenantId=[" + tenantId + "] transaction=" + transaction + " startTime=" + startTime + " endTime=" + endTime);
        }
        String path = "analytics/boundendpoints/%s?startTime=%d&endTime=%d";
        return (List)this.getResultsForUrl(tenantId, URIINFO_LIST, path, new Object[]{transaction, startTime, endTime});
    }

    public List<TransactionInfo> getTransactionInfo(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get transaction info: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/transactions?criteria=%s";
        return (List)this.getResultsForUrl(tenantId, TRANSACTION_INFO_LIST, path, criteria);
    }

    public List<PropertyInfo> getPropertyInfo(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get property info: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/properties?criteria=%s";
        return (List)this.getResultsForUrl(tenantId, PROPERTY_INFO_LIST, path, criteria);
    }

    public long getTraceCompletionCount(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion count: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/trace/completion/count?criteria=%s";
        return (Long)this.getResultsForUrl(tenantId, LONG, path, criteria);
    }

    public long getTraceCompletionFaultCount(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion fault count: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/trace/completion/faultcount?criteria=%s";
        return (Long)this.getResultsForUrl(tenantId, LONG, path, criteria);
    }

    public List<CompletionTime> getTraceCompletions(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion times: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/trace/completion/times?criteria=%s";
        return (List)this.getResultsForUrl(tenantId, COMPLETION_TIME_LIST, path, criteria);
    }

    public Percentiles getTraceCompletionPercentiles(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion percentiles: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/trace/completion/percentiles?criteria=%s";
        return (Percentiles)this.getResultsForUrl(tenantId, PERCENTILES_TYPE_REFERENCE, path, criteria);
    }

    public List<TimeseriesStatistics> getTraceCompletionTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " interval=" + interval);
        }
        String path = "analytics/trace/completion/statistics?criteria=%s&interval=%d";
        return (List)this.getResultsForUrl(tenantId, TIMESERIES_STATISTICS_LIST, path, criteria, interval);
    }

    public List<Cardinality> getTraceCompletionFaultDetails(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion fault details: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/trace/completion/faults?criteria=%s";
        return (List)this.getResultsForUrl(tenantId, CARDINALITY_LIST, path, criteria);
    }

    public List<Cardinality> getTraceCompletionPropertyDetails(String tenantId, Criteria criteria, String property) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion property details: tenantId=[" + tenantId + "] criteria=" + criteria + " property=" + property);
        }
        String path = "analytics/trace/completion/property/%2$s/?criteria=%1$s";
        return (List)this.getResultsForUrl(tenantId, CARDINALITY_LIST, path, criteria, property);
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get node timeseries statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " interval=" + interval);
        }
        if (criteria.parameters().isEmpty()) {
            String path = "analytics/node/statistics?interval=%d";
            return (List)this.getResultsForUrl(tenantId, NODE_TIMESERIES_STATISTICS_LIST, path, new Object[]{interval});
        }
        String path = "analytics/node/statistics?criteria=%s&interval=%d";
        return (List)this.getResultsForUrl(tenantId, NODE_TIMESERIES_STATISTICS_LIST, path, criteria, interval);
    }

    public Collection<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get node summary statistics: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/node/summary?criteria=%s";
        return (Collection)this.getResultsForUrl(tenantId, NODE_SUMMARY_STATISTICS_LIST, path, criteria);
    }

    public Collection<CommunicationSummaryStatistics> getCommunicationSummaryStatistics(String tenantId, Criteria criteria, boolean tree) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get communication summary statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " as tree? " + tree);
        }
        if (criteria.parameters().isEmpty()) {
            String path = "analytics/communication/summary?tree=%b";
            return (Collection)this.getResultsForUrl(tenantId, COMMS_SUMMARY_STATISTICS_LIST, path, new Object[]{tree});
        }
        String path = "analytics/communication/summary?criteria=%s&tree=%b";
        return (Collection)this.getResultsForUrl(tenantId, COMMS_SUMMARY_STATISTICS_LIST, path, criteria, tree);
    }

    public void storeCommunicationDetails(String tenantId, List<CommunicationDetails> communicationDetails) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void storeTraceCompletions(String tenantId, List<CompletionTime> completionTimes) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public List<TimeseriesStatistics> getEndpointResponseTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get endpoint response statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " interval=" + interval);
        }
        String path = "analytics/endpoint/response/statistics?criteria=%s&interval=%d";
        return (List)this.getResultsForUrl(tenantId, TIMESERIES_STATISTICS_LIST, path, criteria, interval);
    }

    public Set<String> getHostNames(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get host names: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        String path = "analytics/hostnames?criteria=%s";
        return (Set)this.getResultsForUrl(tenantId, STRING_SET, path, criteria);
    }

    public void clear(String tenantId) {
        this.clear(tenantId, "analytics");
    }
}

