/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.SpanContext;
import io.opentracing.impl.APMSpan;
import io.opentracing.impl.APMSpanBuilder;
import io.opentracing.impl.AbstractTracer;
import io.opentracing.propagation.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.client.api.recorder.BatchTraceRecorder;
import org.hawkular.apm.client.api.recorder.TraceRecorder;
import org.hawkular.apm.client.api.sampler.ContextSampler;
import org.hawkular.apm.client.api.sampler.Sampler;
import org.hawkular.apm.client.opentracing.APMTracer;

public abstract class AbstractAPMTracer
extends AbstractTracer {
    private static final Logger log = Logger.getLogger((String)APMTracer.class.getName());
    private TraceRecorder recorder;
    private ContextSampler sampler;

    public AbstractAPMTracer() {
        this.recorder = new BatchTraceRecorder();
    }

    public AbstractAPMTracer(TraceRecorder recorder, Sampler sampler) {
        this.recorder = recorder;
        this.sampler = new ContextSampler(sampler);
    }

    public void setTraceRecorder(TraceRecorder recorder) {
        this.recorder = recorder;
    }

    APMSpanBuilder createSpanBuilder(String operationName) {
        return new APMSpanBuilder(operationName, this.recorder, this.sampler);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (spanContext instanceof APMSpan) {
            ((APMSpan)spanContext).setInteractionId(UUID.randomUUID().toString());
            ((APMSpan)spanContext).getNodeBuilder().setNodeType(NodeType.Producer);
        }
        super.inject(spanContext, format, carrier);
    }

    Map<String, Object> getTraceState(SpanContext spanContext) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (spanContext instanceof APMSpan) {
            APMSpan span = (APMSpan)spanContext;
            if (span.getInteractionId() != null) {
                ret.put("HWKAPMID", span.getInteractionId());
            } else {
                log.warning("No id available to include in trace state for context = " + spanContext);
            }
            ret.putAll(span.state());
        }
        return ret;
    }
}

