/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.JSAPIWriter;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.jsapi.i18n.LogMessages;
import org.jboss.resteasy.jsapi.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JSAPIServlet
extends HttpServlet {
    private static final String JS_MEDIA_TYPE = "application/javascript";
    private static final long serialVersionUID = -1985015444704126795L;
    private Map<String, ServiceRegistry> services;
    private JSAPIWriter apiWriter = new JSAPIWriter();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.info(Messages.MESSAGES.loadingJSAPIServlet());
        }
        this.scanResources();
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.jsapiServletLoaded());
        }
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.serving(pathInfo));
            LogMessages.LOGGER.debug(Messages.MESSAGES.query(req.getQueryString()));
        }
        if (this.services == null) {
            this.scanResources();
        }
        if (this.services == null) {
            resp.sendError(503, Messages.MESSAGES.thereAreNoResteasyDeployments());
        }
        resp.setContentType(JS_MEDIA_TYPE);
        this.apiWriter.writeJavaScript(uri, req, resp, this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        Map deployments = (Map)servletContext.getAttribute("resteasy.deployments");
        if (deployments == null) {
            return;
        }
        JSAPIServlet jSAPIServlet = this;
        synchronized (jSAPIServlet) {
            this.services = new HashMap<String, ServiceRegistry>();
            for (Map.Entry entry : deployments.entrySet()) {
                ResourceMethodRegistry registry = (ResourceMethodRegistry)((ResteasyDeployment)entry.getValue()).getRegistry();
                ResteasyProviderFactory providerFactory = ((ResteasyDeployment)entry.getValue()).getProviderFactory();
                ServiceRegistry service = new ServiceRegistry(null, registry, providerFactory, null);
                this.services.put((String)entry.getKey(), service);
            }
        }
    }
}

