/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionBasedActionHandler;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.Severity;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.txn.Processor;
import shaded.org.hawkular.apm.api.model.config.txn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.config.txn.SetPropertyAction;
import shaded.org.hawkular.apm.api.model.trace.Issue;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.ProcessorIssue;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public class SetPropertyActionHandler
extends ExpressionBasedActionHandler {
    public static final String NAME_MUST_BE_SPECIFIED = "Name must be specified";

    public SetPropertyActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        SetPropertyAction action = (SetPropertyAction)this.getAction();
        if (action.getName() == null || action.getName().trim().isEmpty()) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("name");
            pi.setSeverity(Severity.Error);
            pi.setDescription(NAME_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(trace, node, direction, headers, values) && (value = this.getValue(trace, node, direction, headers, values)) != null && ((SetPropertyAction)this.getAction()).getName() != null) {
            node.getProperties().add(new Property(((SetPropertyAction)this.getAction()).getName(), value, ((SetPropertyAction)this.getAction()).getType()));
            return true;
        }
        return false;
    }
}

